import * as _heroui_system_rsc from '@heroui/system-rsc';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system-rsc';
import { SpacerVariantProps } from '@heroui/theme';
import { ReactRef } from '@heroui/react-utils';
import { Space } from './utils.mjs';

interface Props extends HTMLHeroUIProps<"span"> {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLElement | null>;
    /**
     * The x-axis margin.
     * @default 1
     *
     * @see https://tailwindcss.com/docs/customizing-spacing#default-spacing-scale
     */
    x?: Space;
    /**
     * The y-axis margin.
     * @default 1
     *
     * @see https://tailwindcss.com/docs/customizing-spacing#default-spacing-scale
     */
    y?: Space;
}
type UseSpacerProps = Props & SpacerVariantProps;
declare const getMargin: (value: Space) => string;
declare function useSpacer(originalProps: UseSpacerProps): {
    Component: _heroui_system_rsc.As<any>;
    getSpacerProps: PropGetter;
};
type UseSpacerReturn = ReturnType<typeof useSpacer>;

export { type UseSpacerProps, type UseSpacerReturn, getMargin, useSpacer };
