import * as react from 'react';
import { ReactNode } from 'react';
import * as _heroui_theme from '@heroui/theme';
import { SlotsToClasses, UserSlots } from '@heroui/theme';
import * as tailwind_variants from 'tailwind-variants';
import * as _heroui_system from '@heroui/system';
import { HTMLHeroUIProps, PropGetter } from '@heroui/system';
import { AvatarProps } from '@heroui/avatar';
import { ReactRef } from '@heroui/react-utils';

interface Props {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLDivElement | null>;
    /**
     * The user name.
     */
    name: ReactNode;
    /**
     * The user information, like email, phone, etc.
     */
    description?: ReactNode;
    /**
     * Whether the user can be focused.
     * @default false
     */
    isFocusable?: boolean;
    /**
     * The user avatar props
     * @see https://heroui.com/docs/components/avatar
     */
    avatarProps?: Partial<AvatarProps>;
    /**
     * Classname or List of classes to change the classNames of the avatar.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     * <User classNames={{
     *    base:"base-classes",
     *    wrapper: "wrapper-classes",
     *    name: "name-classes",
     *    description: "description-classes",
     * }} />
     * ```
     */
    classNames?: SlotsToClasses<UserSlots>;
}
type UseUserProps = Props & Omit<HTMLHeroUIProps<"div">, "children">;
declare function useUser(props: UseUserProps): {
    Component: _heroui_system.As<any>;
    className: string | undefined;
    slots: {
        base: (slotProps?: ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({} & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        wrapper: (slotProps?: ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({} & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        name: (slotProps?: ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({} & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        description: (slotProps?: ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({} & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {
        base: (slotProps?: ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({} & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        wrapper: (slotProps?: ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({} & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        name: (slotProps?: ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({} & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        description: (slotProps?: ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({
            [x: string]: string | number | undefined;
            [x: number]: string | number | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | ({} & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {};
    name: ReactNode;
    description: ReactNode;
    classNames: SlotsToClasses<"base" | "description" | "name" | "wrapper"> | undefined;
    baseStyles: string;
    avatarProps: {
        ref?: ReactRef<HTMLSpanElement | null> | undefined;
        imgRef?: ReactRef<HTMLImageElement> | undefined;
        name?: string | undefined;
        src?: string | undefined;
        alt?: string | undefined;
        icon?: ReactNode;
        isFocusable: boolean;
        ignoreFallback?: boolean | undefined;
        showFallback?: boolean | undefined;
        getInitials?: ((name: string) => string) | undefined;
        fallback?: ReactNode;
        onError?: (() => void) | undefined;
        ImgComponent?: React.ElementType | undefined;
        imgProps?: React.ImgHTMLAttributes<HTMLImageElement> | undefined;
        classNames?: SlotsToClasses<_heroui_theme.AvatarSlots> | undefined;
        style?: react.CSSProperties | undefined;
        title?: string | undefined | undefined;
        as?: _heroui_system.As | undefined;
        key?: react.Key | null | undefined;
        children?: ReactNode;
        id?: string | undefined | undefined;
        role?: react.AriaRole | undefined;
        tabIndex?: number | undefined | undefined;
        accessKey?: string | undefined | undefined;
        autoFocus?: boolean | undefined | undefined;
        className?: string | undefined | undefined;
        content?: string | undefined | undefined;
        contentEditable?: (boolean | "true" | "false") | "inherit" | undefined;
        contextMenu?: string | undefined | undefined;
        dir?: string | undefined | undefined;
        draggable?: (boolean | "true" | "false") | undefined;
        hidden?: boolean | undefined | undefined;
        inputMode?: "none" | "text" | "tel" | "url" | "email" | "numeric" | "decimal" | "search" | undefined | undefined;
        itemProp?: string | undefined | undefined;
        itemRef?: string | undefined | undefined;
        itemScope?: boolean | undefined | undefined;
        itemType?: string | undefined | undefined;
        lang?: string | undefined | undefined;
        placeholder?: string | undefined | undefined;
        radioGroup?: string | undefined | undefined;
        rel?: string | undefined | undefined;
        spellCheck?: (boolean | "true" | "false") | undefined;
        translate?: "yes" | "no" | undefined | undefined;
        onCopy?: react.ClipboardEventHandler<HTMLSpanElement> | undefined;
        onCut?: react.ClipboardEventHandler<HTMLSpanElement> | undefined;
        onPaste?: react.ClipboardEventHandler<HTMLSpanElement> | undefined;
        onLoad?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onWheel?: react.WheelEventHandler<HTMLSpanElement> | undefined;
        onScroll?: react.UIEventHandler<HTMLSpanElement> | undefined;
        onCompositionEnd?: react.CompositionEventHandler<HTMLSpanElement> | undefined;
        onCompositionStart?: react.CompositionEventHandler<HTMLSpanElement> | undefined;
        onCompositionUpdate?: react.CompositionEventHandler<HTMLSpanElement> | undefined;
        onKeyDown?: react.KeyboardEventHandler<HTMLSpanElement> | undefined;
        onKeyPress?: react.KeyboardEventHandler<HTMLSpanElement> | undefined;
        onKeyUp?: react.KeyboardEventHandler<HTMLSpanElement> | undefined;
        onFocus?: react.FocusEventHandler<HTMLSpanElement> | undefined;
        onBlur?: react.FocusEventHandler<HTMLSpanElement> | undefined;
        onChange?: react.FormEventHandler<HTMLSpanElement> | undefined;
        onInput?: react.FormEventHandler<HTMLSpanElement> | undefined;
        onSubmit?: react.FormEventHandler<HTMLSpanElement> | undefined;
        onClick?: react.MouseEventHandler<HTMLSpanElement> | undefined;
        onContextMenu?: react.MouseEventHandler<HTMLSpanElement> | undefined;
        onDoubleClick?: react.MouseEventHandler<HTMLSpanElement> | undefined;
        onDrag?: react.DragEventHandler<HTMLSpanElement> | undefined;
        onDragEnd?: react.DragEventHandler<HTMLSpanElement> | undefined;
        onDragEnter?: react.DragEventHandler<HTMLSpanElement> | undefined;
        onDragExit?: react.DragEventHandler<HTMLSpanElement> | undefined;
        onDragLeave?: react.DragEventHandler<HTMLSpanElement> | undefined;
        onDragOver?: react.DragEventHandler<HTMLSpanElement> | undefined;
        onDragStart?: react.DragEventHandler<HTMLSpanElement> | undefined;
        onDrop?: react.DragEventHandler<HTMLSpanElement> | undefined;
        onMouseDown?: react.MouseEventHandler<HTMLSpanElement> | undefined;
        onMouseEnter?: react.MouseEventHandler<HTMLSpanElement> | undefined;
        onMouseLeave?: react.MouseEventHandler<HTMLSpanElement> | undefined;
        onMouseMove?: react.MouseEventHandler<HTMLSpanElement> | undefined;
        onMouseOut?: react.MouseEventHandler<HTMLSpanElement> | undefined;
        onMouseOver?: react.MouseEventHandler<HTMLSpanElement> | undefined;
        onMouseUp?: react.MouseEventHandler<HTMLSpanElement> | undefined;
        onPointerDown?: react.PointerEventHandler<HTMLSpanElement> | undefined;
        onPointerEnter?: react.PointerEventHandler<HTMLSpanElement> | undefined;
        onPointerLeave?: react.PointerEventHandler<HTMLSpanElement> | undefined;
        onPointerUp?: react.PointerEventHandler<HTMLSpanElement> | undefined;
        onSelect?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onTouchCancel?: react.TouchEventHandler<HTMLSpanElement> | undefined;
        onTouchEnd?: react.TouchEventHandler<HTMLSpanElement> | undefined;
        onTouchMove?: react.TouchEventHandler<HTMLSpanElement> | undefined;
        onTouchStart?: react.TouchEventHandler<HTMLSpanElement> | undefined;
        onAnimationStart?: react.AnimationEventHandler<HTMLSpanElement> | undefined;
        onAnimationEnd?: react.AnimationEventHandler<HTMLSpanElement> | undefined;
        onAnimationIteration?: react.AnimationEventHandler<HTMLSpanElement> | undefined;
        onTransitionEnd?: react.TransitionEventHandler<HTMLSpanElement> | undefined;
        'aria-label'?: string | undefined | undefined;
        'aria-labelledby'?: string | undefined | undefined;
        'aria-describedby'?: string | undefined | undefined;
        'aria-details'?: string | undefined | undefined;
        'aria-activedescendant'?: string | undefined | undefined;
        'aria-atomic'?: (boolean | "true" | "false") | undefined;
        'aria-autocomplete'?: "none" | "inline" | "list" | "both" | undefined | undefined;
        'aria-busy'?: (boolean | "true" | "false") | undefined;
        'aria-checked'?: boolean | "false" | "mixed" | "true" | undefined | undefined;
        'aria-colcount'?: number | undefined | undefined;
        'aria-colindex'?: number | undefined | undefined;
        'aria-colspan'?: number | undefined | undefined;
        'aria-controls'?: string | undefined | undefined;
        'aria-current'?: boolean | "false" | "true" | "page" | "step" | "location" | "date" | "time" | undefined | undefined;
        'aria-disabled'?: (boolean | "true" | "false") | undefined;
        'aria-dropeffect'?: "none" | "copy" | "execute" | "link" | "move" | "popup" | undefined | undefined;
        'aria-errormessage'?: string | undefined | undefined;
        'aria-expanded'?: (boolean | "true" | "false") | undefined;
        'aria-flowto'?: string | undefined | undefined;
        'aria-grabbed'?: (boolean | "true" | "false") | undefined;
        'aria-haspopup'?: boolean | "false" | "true" | "menu" | "listbox" | "tree" | "grid" | "dialog" | undefined | undefined;
        'aria-hidden'?: (boolean | "true" | "false") | undefined;
        'aria-invalid'?: boolean | "false" | "true" | "grammar" | "spelling" | undefined | undefined;
        'aria-keyshortcuts'?: string | undefined | undefined;
        'aria-level'?: number | undefined | undefined;
        'aria-live'?: "off" | "assertive" | "polite" | undefined | undefined;
        'aria-modal'?: (boolean | "true" | "false") | undefined;
        'aria-multiline'?: (boolean | "true" | "false") | undefined;
        'aria-multiselectable'?: (boolean | "true" | "false") | undefined;
        'aria-orientation'?: "horizontal" | "vertical" | undefined | undefined;
        'aria-owns'?: string | undefined | undefined;
        'aria-placeholder'?: string | undefined | undefined;
        'aria-posinset'?: number | undefined | undefined;
        'aria-pressed'?: boolean | "false" | "mixed" | "true" | undefined | undefined;
        'aria-readonly'?: (boolean | "true" | "false") | undefined;
        'aria-relevant'?: "additions" | "additions removals" | "additions text" | "all" | "removals" | "removals additions" | "removals text" | "text" | "text additions" | "text removals" | undefined | undefined;
        'aria-required'?: (boolean | "true" | "false") | undefined;
        'aria-roledescription'?: string | undefined | undefined;
        'aria-rowcount'?: number | undefined | undefined;
        'aria-rowindex'?: number | undefined | undefined;
        'aria-rowspan'?: number | undefined | undefined;
        'aria-selected'?: (boolean | "true" | "false") | undefined;
        'aria-setsize'?: number | undefined | undefined;
        'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined | undefined;
        'aria-valuemax'?: number | undefined | undefined;
        'aria-valuemin'?: number | undefined | undefined;
        'aria-valuenow'?: number | undefined | undefined;
        'aria-valuetext'?: string | undefined | undefined;
        dangerouslySetInnerHTML?: {
            __html: string | TrustedHTML;
        } | undefined | undefined;
        onCopyCapture?: react.ClipboardEventHandler<HTMLSpanElement> | undefined;
        onCutCapture?: react.ClipboardEventHandler<HTMLSpanElement> | undefined;
        onPasteCapture?: react.ClipboardEventHandler<HTMLSpanElement> | undefined;
        onCompositionEndCapture?: react.CompositionEventHandler<HTMLSpanElement> | undefined;
        onCompositionStartCapture?: react.CompositionEventHandler<HTMLSpanElement> | undefined;
        onCompositionUpdateCapture?: react.CompositionEventHandler<HTMLSpanElement> | undefined;
        onFocusCapture?: react.FocusEventHandler<HTMLSpanElement> | undefined;
        onBlurCapture?: react.FocusEventHandler<HTMLSpanElement> | undefined;
        onChangeCapture?: react.FormEventHandler<HTMLSpanElement> | undefined;
        onBeforeInput?: react.FormEventHandler<HTMLSpanElement> | undefined;
        onBeforeInputCapture?: react.FormEventHandler<HTMLSpanElement> | undefined;
        onInputCapture?: react.FormEventHandler<HTMLSpanElement> | undefined;
        onReset?: react.FormEventHandler<HTMLSpanElement> | undefined;
        onResetCapture?: react.FormEventHandler<HTMLSpanElement> | undefined;
        onSubmitCapture?: react.FormEventHandler<HTMLSpanElement> | undefined;
        onInvalid?: react.FormEventHandler<HTMLSpanElement> | undefined;
        onInvalidCapture?: react.FormEventHandler<HTMLSpanElement> | undefined;
        onLoadCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onErrorCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onKeyDownCapture?: react.KeyboardEventHandler<HTMLSpanElement> | undefined;
        onKeyPressCapture?: react.KeyboardEventHandler<HTMLSpanElement> | undefined;
        onKeyUpCapture?: react.KeyboardEventHandler<HTMLSpanElement> | undefined;
        onAbort?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onAbortCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onCanPlay?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onCanPlayCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onCanPlayThrough?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onCanPlayThroughCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onDurationChange?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onDurationChangeCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onEmptied?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onEmptiedCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onEncrypted?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onEncryptedCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onEnded?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onEndedCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onLoadedData?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onLoadedDataCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onLoadedMetadata?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onLoadedMetadataCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onLoadStart?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onLoadStartCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onPause?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onPauseCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onPlay?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onPlayCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onPlaying?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onPlayingCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onProgress?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onProgressCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onRateChange?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onRateChangeCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onResize?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onResizeCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onSeeked?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onSeekedCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onSeeking?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onSeekingCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onStalled?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onStalledCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onSuspend?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onSuspendCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onTimeUpdate?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onTimeUpdateCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onVolumeChange?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onVolumeChangeCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onWaiting?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onWaitingCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onAuxClick?: react.MouseEventHandler<HTMLSpanElement> | undefined;
        onAuxClickCapture?: react.MouseEventHandler<HTMLSpanElement> | undefined;
        onClickCapture?: react.MouseEventHandler<HTMLSpanElement> | undefined;
        onContextMenuCapture?: react.MouseEventHandler<HTMLSpanElement> | undefined;
        onDoubleClickCapture?: react.MouseEventHandler<HTMLSpanElement> | undefined;
        onDragCapture?: react.DragEventHandler<HTMLSpanElement> | undefined;
        onDragEndCapture?: react.DragEventHandler<HTMLSpanElement> | undefined;
        onDragEnterCapture?: react.DragEventHandler<HTMLSpanElement> | undefined;
        onDragExitCapture?: react.DragEventHandler<HTMLSpanElement> | undefined;
        onDragLeaveCapture?: react.DragEventHandler<HTMLSpanElement> | undefined;
        onDragOverCapture?: react.DragEventHandler<HTMLSpanElement> | undefined;
        onDragStartCapture?: react.DragEventHandler<HTMLSpanElement> | undefined;
        onDropCapture?: react.DragEventHandler<HTMLSpanElement> | undefined;
        onMouseDownCapture?: react.MouseEventHandler<HTMLSpanElement> | undefined;
        onMouseMoveCapture?: react.MouseEventHandler<HTMLSpanElement> | undefined;
        onMouseOutCapture?: react.MouseEventHandler<HTMLSpanElement> | undefined;
        onMouseOverCapture?: react.MouseEventHandler<HTMLSpanElement> | undefined;
        onMouseUpCapture?: react.MouseEventHandler<HTMLSpanElement> | undefined;
        onSelectCapture?: react.ReactEventHandler<HTMLSpanElement> | undefined;
        onTouchCancelCapture?: react.TouchEventHandler<HTMLSpanElement> | undefined;
        onTouchEndCapture?: react.TouchEventHandler<HTMLSpanElement> | undefined;
        onTouchMoveCapture?: react.TouchEventHandler<HTMLSpanElement> | undefined;
        onTouchStartCapture?: react.TouchEventHandler<HTMLSpanElement> | undefined;
        onPointerDownCapture?: react.PointerEventHandler<HTMLSpanElement> | undefined;
        onPointerMove?: react.PointerEventHandler<HTMLSpanElement> | undefined;
        onPointerMoveCapture?: react.PointerEventHandler<HTMLSpanElement> | undefined;
        onPointerUpCapture?: react.PointerEventHandler<HTMLSpanElement> | undefined;
        onPointerCancel?: react.PointerEventHandler<HTMLSpanElement> | undefined;
        onPointerCancelCapture?: react.PointerEventHandler<HTMLSpanElement> | undefined;
        onPointerEnterCapture?: react.PointerEventHandler<HTMLSpanElement> | undefined;
        onPointerLeaveCapture?: react.PointerEventHandler<HTMLSpanElement> | undefined;
        onPointerOver?: react.PointerEventHandler<HTMLSpanElement> | undefined;
        onPointerOverCapture?: react.PointerEventHandler<HTMLSpanElement> | undefined;
        onPointerOut?: react.PointerEventHandler<HTMLSpanElement> | undefined;
        onPointerOutCapture?: react.PointerEventHandler<HTMLSpanElement> | undefined;
        onGotPointerCapture?: react.PointerEventHandler<HTMLSpanElement> | undefined;
        onGotPointerCaptureCapture?: react.PointerEventHandler<HTMLSpanElement> | undefined;
        onLostPointerCapture?: react.PointerEventHandler<HTMLSpanElement> | undefined;
        onLostPointerCaptureCapture?: react.PointerEventHandler<HTMLSpanElement> | undefined;
        onScrollCapture?: react.UIEventHandler<HTMLSpanElement> | undefined;
        onWheelCapture?: react.WheelEventHandler<HTMLSpanElement> | undefined;
        onAnimationStartCapture?: react.AnimationEventHandler<HTMLSpanElement> | undefined;
        onAnimationEndCapture?: react.AnimationEventHandler<HTMLSpanElement> | undefined;
        onAnimationIterationCapture?: react.AnimationEventHandler<HTMLSpanElement> | undefined;
        onTransitionEndCapture?: react.TransitionEventHandler<HTMLSpanElement> | undefined;
        nonce?: string | undefined | undefined;
        prefix?: string | undefined | undefined;
        suppressContentEditableWarning?: boolean | undefined | undefined;
        suppressHydrationWarning?: boolean | undefined | undefined;
        about?: string | undefined | undefined;
        datatype?: string | undefined | undefined;
        inlist?: any;
        property?: string | undefined | undefined;
        resource?: string | undefined | undefined;
        rev?: string | undefined | undefined;
        typeof?: string | undefined | undefined;
        vocab?: string | undefined | undefined;
        autoCapitalize?: string | undefined | undefined;
        autoCorrect?: string | undefined | undefined;
        autoSave?: string | undefined | undefined;
        itemID?: string | undefined | undefined;
        results?: number | undefined | undefined;
        security?: string | undefined | undefined;
        unselectable?: "on" | "off" | undefined | undefined;
        is?: string | undefined | undefined;
        color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
        size?: "sm" | "md" | "lg" | undefined;
        disableAnimation?: boolean | undefined;
        radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
        isBordered?: boolean | undefined;
        isDisabled?: boolean | undefined;
    };
    getUserProps: PropGetter;
};
type UseUserReturn = ReturnType<typeof useUser>;

export { type UseUserProps, type UseUserReturn, useUser };
