<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $accessCode = trim($_POST['access_code']);
    
    if (!empty($accessCode)) {
        require_once 'db.php';
        
        try {
            $stmt = $pdo->prepare("SELECT * FROM users WHERE code = ?");
            $stmt->execute([$accessCode]);
            $user = $stmt->fetch();
            
            if ($user) {
                $_SESSION['user_logged_in'] = true;
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_code'] = $user['code'];
                
                header('Location: dashboard.php');
                exit();
            } else {
                $error = 'invalid';
            }
        } catch (Exception $e) {
            $error = 'invalid';
        }
    } else {
        $error = 'empty';
    }
}

if (isset($_GET['error'])) {
    $error = $_GET['error'];
}
?>
<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Member Access - aktascorp</title>
    <link rel="icon" type="image/png" href="ac.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Raleway:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Raleway', sans-serif;
            background-color: #f9f0e6;
        }
    </style>
</head>
<body class="text-gray-800 min-h-screen flex items-center justify-center">

    <div class="w-full max-w-sm mx-auto">
        <div class="text-center mb-8">
            <h1 class="text-3xl font-light tracking-wider text-gray-800 mb-2">aktascorp</h1>
            <p class="text-sm text-gray-600">member portal</p>
        </div>

        <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-8">
            <h2 class="text-xl font-medium text-center mb-6">Access Code</h2>
            
            <form method="POST">
                <div class="mb-6">
                    <input 
                        type="password" 
                        id="access_code" 
                        name="access_code" 
                        required 
                        class="w-full px-4 py-3 text-center text-lg font-mono border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-gray-400 focus:border-transparent"
                        placeholder="••••••••"
                        maxlength="8"
                    >
                </div>

                <button 
                    type="submit" 
                    class="w-full bg-gray-800 text-white py-3 rounded-lg font-medium hover:bg-gray-700 transition duration-200"
                >
                    Access
                </button>
            </form>

            <?php if (isset($error)): ?>
                <div class="mt-4 p-3 bg-red-50 border border-red-200 rounded text-center">
                    <p class="text-sm text-red-600">
                        <?php if ($error == 'invalid'): ?>
                            Invalid code
                        <?php elseif ($error == 'empty'): ?>
                            Enter your code
                        <?php endif; ?>
                    </p>
                </div>
            <?php endif; ?>
        </div>

        <div class="text-center mt-6">
            <a href="/" class="text-sm text-gray-600 hover:text-gray-800">← Back to aktascorp</a>
        </div>
    </div>

    <script>
        document.getElementById('access_code').addEventListener('input', function(e) {
            this.value = this.value.replace(/[^0-9]/g, '');
        });
        document.getElementById('access_code').focus();
    </script>

</body>
</html>