<?php

// Fonction pour générer un ID unique
function genererIdTransfert($longueur = 8) {
    $caracteres = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $id = '';
    for ($i = 0; $i < $longueur; $i++) {
        $id .= $caracteres[rand(0, strlen($caracteres) - 1)];
    }
    return $id;
}

// Vérifier si l'utilisateur a déjà une identité
$sql = "SELECT * FROM identites WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if($result->num_rows > 0) {
    // L'utilisateur a déjà une identité, mettre à jour le code de transfert
    $nouveau_code = genererIdTransfert();
    
    // Vérifier que le code n'existe pas déjà
    $unique = false;
    while(!$unique) {
        $sql = "SELECT * FROM identites WHERE code_transfert = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $nouveau_code);
        $stmt->execute();
        $check_result = $stmt->get_result();
        
        if($check_result->num_rows == 0) {
            $unique = true;
        } else {
            $nouveau_code = genererIdTransfert();
        }
    }
    
    $sql = "UPDATE identites SET code_transfert = ? WHERE user_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("si", $nouveau_code, $user_id);
    
    if($stmt->execute()) {
        // Rafraîchir les données d'identité
        $identite['code_transfert'] = $nouveau_code;
        
        $generation_message = "Votre ID de transfert a été généré avec succès.";
        $generation_success = true;
    } else {
        $generation_message = "Une erreur est survenue lors de la génération de l'ID.";
        $generation_success = false;
    }
} else {
    $generation_message = "Vous devez d'abord créer votre identité avant de générer un ID de transfert.";
    $generation_success = false;
}
?>