<?php
$lignes_train = explode(',', $_POST['ligne_train']);
$gare_depart = $_POST['gare_depart'];
$gare_arrivee = $_POST['gare_arrivee'];
$date_voyage_train = $_POST['date_voyage_train'];

$train_success = false;
$train_message = "";

if (empty($_POST['ligne_train']) || empty($gare_depart) || empty($gare_arrivee) || empty($date_voyage_train)) {
    $train_message = "Tous les champs sont obligatoires.";
} elseif ($gare_depart == $gare_arrivee) {
    $train_message = "La gare de départ et d'arrivée ne peuvent pas être identiques.";
} elseif (strtotime($date_voyage_train) < strtotime(date('Y-m-d'))) {
    $train_message = "La date de voyage ne peut pas être dans le passé.";
} else {
    $placeholders = implode(',', array_fill(0, count($lignes_train), '?'));
    $types = str_repeat('s', count($lignes_train) + 2);
    
    $sql = "SELECT DISTINCT nom FROM gares_train WHERE nom IN (?, ?) AND ligne IN ($placeholders) AND statut = 'ouverte'";
    $stmt = $conn->prepare($sql);
    
    $params = array_merge([$gare_depart, $gare_arrivee], $lignes_train);
    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows < 2) {
        $train_message = "Une ou plusieurs gares sont fermées ou inexistantes sur cette ligne.";
    } else {
        $distance_totale = 0;
        
        foreach($lignes_train as $ligne) {
            $sql = "SELECT position FROM gares_train WHERE nom = ? AND ligne = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ss", $gare_depart, $ligne);
            $stmt->execute();
            $result_depart = $stmt->get_result();
            
            if($result_depart->num_rows > 0) {
                $pos_depart = $result_depart->fetch_assoc()['position'];
                
                $stmt->bind_param("ss", $gare_arrivee, $ligne);
                $stmt->execute();
                $result_arrivee = $stmt->get_result();
                
                if($result_arrivee->num_rows > 0) {
                    $pos_arrivee = $result_arrivee->fetch_assoc()['position'];
                    $distance_totale = abs($pos_arrivee - $pos_depart);
                    break;
                } else {
                    $sql = "SELECT position, nom FROM gares_train WHERE ligne = ? ORDER BY position";
                    $stmt2 = $conn->prepare($sql);
                    $stmt2->bind_param("s", $ligne);
                    $stmt2->execute();
                    $gares_ligne = $stmt2->get_result()->fetch_all(MYSQLI_ASSOC);
                    
                    foreach($gares_ligne as $gare) {
                        if($gare['nom'] == $gare_depart) {
                            $pos_depart = $gare['position'];
                        }
                    }
                    
                    $correspondance_pos = null;
                    foreach($gares_ligne as $gare) {
                        $check_autre_ligne = $conn->prepare("SELECT 1 FROM gares_train WHERE nom = ? AND ligne != ?");
                        $check_autre_ligne->bind_param("ss", $gare['nom'], $ligne);
                        $check_autre_ligne->execute();
                        if($check_autre_ligne->get_result()->num_rows > 0) {
                            $correspondance_pos = $gare['position'];
                            break;
                        }
                    }
                    
                    if($correspondance_pos !== null) {
                        $distance_totale += abs($correspondance_pos - $pos_depart);
                    }
                }
            }
        }
        
        if(count($lignes_train) > 1) {
            $ligne_arrivee = end($lignes_train);
            $sql = "SELECT position FROM gares_train WHERE nom = ? AND ligne = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ss", $gare_arrivee, $ligne_arrivee);
            $stmt->execute();
            $result_arrivee = $stmt->get_result();
            
            if($result_arrivee->num_rows > 0) {
                $pos_arrivee_finale = $result_arrivee->fetch_assoc()['position'];
                
                $sql = "SELECT position, nom FROM gares_train WHERE ligne = ? ORDER BY position";
                $stmt2 = $conn->prepare($sql);
                $stmt2->bind_param("s", $ligne_arrivee);
                $stmt2->execute();
                $gares_ligne = $stmt2->get_result()->fetch_all(MYSQLI_ASSOC);
                
                foreach($gares_ligne as $gare) {
                    $check_autre_ligne = $conn->prepare("SELECT 1 FROM gares_train WHERE nom = ? AND ligne != ?");
                    $check_autre_ligne->bind_param("ss", $gare['nom'], $ligne_arrivee);
                    $check_autre_ligne->execute();
                    if($check_autre_ligne->get_result()->num_rows > 0) {
                        $distance_totale += abs($pos_arrivee_finale - $gare['position']);
                        break;
                    }
                }
            }
        }
        
        $prix = $distance_totale * 25;
        
        if ($solde < $prix) {
            $train_message = "Solde insuffisant pour effectuer cette réservation. Solde actuel: " . number_format($solde, 2, ',', ' ') . " F&, Prix requis: " . number_format($prix, 2, ',', ' ') . " F&";
        } else {
            do {
                $id_reservation = str_pad(rand(1000000, 9999999), 7, '0', STR_PAD_LEFT);
                $sql_check = "SELECT id FROM reservations WHERE id_reservation = ?";
                $stmt_check = $conn->prepare($sql_check);
                $stmt_check->bind_param("s", $id_reservation);
                $stmt_check->execute();
            } while ($stmt_check->get_result()->num_rows > 0);
            
            $conn->begin_transaction();
            
            try {
                $ligne_affichage = implode(', ', $lignes_train);
                $sql = "INSERT INTO reservations (id_reservation, user_id, type, gare_depart, gare_arrivee, ligne_train, date_voyage, prix, statut) VALUES (?, ?, 'train', ?, ?, ?, ?, ?, 'confirme')";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("sissssd", $id_reservation, $user_id, $gare_depart, $gare_arrivee, $ligne_affichage, $date_voyage_train, $prix);
                
                if (!$stmt->execute()) {
                    throw new Exception("Erreur lors de l'insertion de la réservation");
                }
                
                $nouveau_solde = $solde - $prix;
                $sql = "UPDATE comptes_bancaires SET solde = ? WHERE user_id = ?";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("di", $nouveau_solde, $user_id);
                
                if (!$stmt->execute()) {
                    throw new Exception("Erreur lors de la mise à jour du solde");
                }
                
                $sql = "INSERT INTO transactions (user_id, destinataire_id, destinataire_nom, emetteur_nom, montant, motif, type) VALUES (?, 1, 'Compagnie Ferroviaire Peerkinton', ?, ?, 'Billet de train - Ligne " . $ligne_affichage . " - " . $gare_depart . " vers " . $gare_arrivee . "', 'paiement')";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("isd", $user_id, $user['email'], $prix);
                
                if (!$stmt->execute()) {
                    throw new Exception("Erreur lors de l'enregistrement de la transaction");
                }
                
                $conn->commit();
                
                $train_success = true;
                $train_message = "Réservation confirmée avec succès ! Votre ID de réservation est : " . $id_reservation . ". Montant débité : " . number_format($prix, 2, ',', ' ') . " F&";
                $solde = $nouveau_solde;
                
            } catch (Exception $e) {
                $conn->rollback();
                $train_message = "Erreur lors de la réservation : " . $e->getMessage();
            }
        }
    }
}
?>