<?php
session_start();

if(isset($_SESSION['user_id'])) {
    header("Location: dashboard.php");
    exit();
}

$token = isset($_GET['token']) ? $_GET['token'] : '';
$token_valid = false;
$token_expired = false;

if($token) {
    require_once 'db.php';
    
    $sql = "SELECT * FROM users WHERE reset_token = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if($result->num_rows > 0) {
        $user = $result->fetch_assoc();
        if(strtotime($user['reset_expiry']) > time()) {
            $token_valid = true;
        } else {
            $token_expired = true;
        }
    }
    
    $stmt->close();
    $conn->close();
}

if(isset($_POST['reset']) && $token_valid) {
    require_once 'db.php';
    
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];
    
    if($new_password === $confirm_password) {
        if(strlen($new_password) >= 8) {
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
            
            $sql = "UPDATE users SET password = ?, reset_token = NULL, reset_expiry = NULL WHERE reset_token = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ss", $hashed_password, $token);
            $stmt->execute();
            
            $success = "Ton mot de passe a été réinitialisé avec succès. Tu peux maintenant te connecter.";
            $token_valid = false;
            
            $stmt->close();
            $conn->close();
        } else {
            $error = "Le mot de passe doit contenir au moins 8 caractères.";
        }
    } else {
        $error = "Les mots de passe ne correspondent pas.";
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Peerkinton - Réinitialisation</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Poppins', 'sans-serif'],
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-white text-gray-900 min-h-screen flex items-center justify-center">
    <div class="w-full px-4 sm:px-6 py-8 sm:py-12">
        <div class="max-w-md mx-auto">
            <div class="mb-10 sm:mb-16 text-center">
                <img src="logo.png" alt="Peerkinton Logo" class="h-6 sm:h-8 mx-auto">
            </div>
            
            <?php if(!$token): ?>
                <div class="text-center mb-6 sm:mb-10">
                    <h1 class="text-3xl sm:text-4xl font-medium mb-3 sm:mb-4">Lien invalide</h1>
                    <p class="text-gray-600 font-light">Le lien de réinitialisation est invalide ou manquant.</p>
                </div>
                <div class="text-center">
                    <a href="login.php" class="inline-block bg-black text-white px-6 py-3 font-medium text-sm uppercase tracking-wider rounded">
                        Retour à la connexion
                    </a>
                </div>
            <?php elseif($token_expired): ?>
                <div class="text-center mb-6 sm:mb-10">
                    <h1 class="text-3xl sm:text-4xl font-medium mb-3 sm:mb-4">Lien expiré</h1>
                    <p class="text-gray-600 font-light">Ce lien de réinitialisation a expiré. Demande un nouveau lien.</p>
                </div>
                <div class="text-center">
                    <a href="login.php" class="inline-block bg-black text-white px-6 py-3 font-medium text-sm uppercase tracking-wider rounded">
                        Retour à la connexion
                    </a>
                </div>
            <?php elseif(isset($success)): ?>
                <div class="text-center mb-6 sm:mb-10">
                    <h1 class="text-3xl sm:text-4xl font-medium mb-3 sm:mb-4">Succès</h1>
                    <div class="bg-green-50 text-green-800 px-4 py-3 rounded mb-6">
                        <?php echo $success; ?>
                    </div>
                </div>
                <div class="text-center">
                    <a href="login.php" class="inline-block bg-black text-white px-6 py-3 font-medium text-sm uppercase tracking-wider rounded">
                        Se connecter
                    </a>
                </div>
            <?php elseif($token_valid): ?>
                <div class="text-center mb-6 sm:mb-10">
                    <h1 class="text-3xl sm:text-4xl font-medium mb-3 sm:mb-4">Nouveau mot de passe</h1>
                    <p class="text-gray-600 font-light">Choisis un nouveau mot de passe pour ton compte.</p>
                </div>
                
                <div class="mb-6">
                    <?php if(isset($error)): ?>
                        <div class="bg-red-50 text-red-800 px-4 py-3 rounded mb-4">
                            <?php echo $error; ?>
                        </div>
                    <?php endif; ?>
                    
                    <form action="" method="POST">
                        <div class="mb-4">
                            <input type="password" name="new_password" required placeholder="Nouveau mot de passe" class="w-full px-4 py-3 bg-gray-50 border-0 focus:ring-0 rounded">
                        </div>
                        <div class="mb-6">
                            <input type="password" name="confirm_password" required placeholder="Confirme le mot de passe" class="w-full px-4 py-3 bg-gray-50 border-0 focus:ring-0 rounded">
                        </div>
                        <button type="submit" name="reset" class="w-full bg-black text-white px-6 py-3 font-medium text-sm uppercase tracking-wider rounded">
                            Réinitialiser
                        </button>
                    </form>
                </div>
                
                <p class="text-gray-600 text-center text-sm">
                    <i class="fas fa-info-circle mr-1"></i>Le mot de passe doit contenir au moins 8 caractères.
                </p>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>