<!DOCTYPE html>
<html lang="ar" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>الدعم</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600&display=swap" rel="stylesheet">
    <style type="text/css">
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
        }
        .bg-image {
            background-image: url('IMG_7530.JPG');
            background-size: cover;
            background-position: center;
            filter: brightness(0.6);
        }
        .faq-item {
            margin-bottom: 1rem;
        }
        .faq-question {
            cursor: pointer;
            padding: 1rem 0;
            display: flex;
            justify-content: space-between;
            align-items: center;
            width: 100%;
            text-align: left;
            background: transparent;
            border: none;
            border-bottom: 1px solid #333;
            color: #fff;
        }
        .faq-answer {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s ease-out;
            padding: 0 1rem;
            opacity: 0;
            transform: translateY(-10px);
        }
        .faq-answer.active {
            max-height: 300px;
            opacity: 1;
            transform: translateY(0);
            transition: all 0.3s ease-in;
            padding: 1rem;
        }
        .contact-email-banner {
            background: linear-gradient(90deg, #3B82F6 0%, #2563EB 100%);
            color: white;
            padding: 0.75rem 1rem;
            text-align: center;
            font-weight: 500;
            margin-bottom: 0;
        }
        .contact-email-link {
            color: white;
            font-weight: 600;
            text-decoration: underline;
            transition: opacity 0.2s ease;
        }
        .contact-email-link:hover {
            opacity: 0.9;
        }
    </style>
</head>
<body class="flex flex-col min-h-screen bg-black text-gray-400">
    <?php include 'src/header.php'; ?>
<!-- Email Banner -->

<header class="relative h-80">
    <div class="bg-image absolute inset-0"></div>
    <div class="absolute inset-0 bg-gradient-to-b from-transparent to-black"></div>
    <div class="container mx-auto px-4 h-full flex items-end pb-12 relative z-10">
        <h1 class="text-5xl font-light text-white tracking-wide">الدعم</h1>
    </div>
</header>

<main class="flex-grow container mx-auto px-4 py-16">
    <div class="max-w-4xl mx-auto space-y-16">
        <div class="text-center space-y-6">
            <h2 class="text-3xl text-white font-light">نحن هنا للمساعدة</h2>
            <p class="text-lg max-w-2xl mx-auto">
            فريق الدعم لدينا متاح على مدار 24 ساعة و 7 أيام في الأسبوع للإجابة على جميع استفساراتكم.
            كل ما عليك هو التواصل معنا عبر البريد الإلكتروني للحصول على المساعدة.
            </p>
        </div>

        <!-- FAQ Section (Commented Out)
        <section class="space-y-8">
            <h2 class="text-3xl text-white font-light text-center">الأسئلة المتكررة</h2>
            <div class="space-y-4 max-w-2xl mx-auto">
                [FAQ section content will be added in next part]
            </div>
        </section>  -->

	<div class="text-center space-y-4">
            <h2 class="text-3xl text-white font-light">الدعم لعملائنا</h2>
            <p class="text-lg">
            يمكن للعملاء الذين لديهم حساب Imators <a href="https://idsma.imators.com" class="underline text-white">إرسال طلبات الدعم من خلال مساحة التذاكر الخاصة بهم.</a>
            </p>
        </div>
        <div class="text-center space-y-4">
            <h2 class="text-3xl text-white font-light">التواصل التجاري والمهني</h2>
            <p class="text-lg">
            فريقنا متاح على <a href="mailto:contact@imators.com" class="text-blue-500 hover:text-blue-400 font-medium">contact@imators.com</a>
            </p>
        </div>
    </div>
</main>

 </a></div></div><div class="w-full md:w-1/3 p-5"><h5 class="text-xs uppercase font-medium mb-6">اكتشف</h5><a href="/ar/privacy" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700"> سياسة الخصوصية </a><a href="/ar/terms-of-use" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700"> شروط الاستخدام </a><a href="/ar/" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700"> الصفحة الرئيسية </a><a href="/ar/about-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700"> معلومات عنا </a><a href="/ar/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700"> اتصل بنا </a></div><div class="w-full md:w-1/3 p-5"><h5 class="text-xs uppercase font-medium mb-6">واقع ممكن</h5><p class="text-sm"> جميع الصور ومقاطع الفيديو والمحتوى الموجود في هذا الموقع هي ملك Imators. </p></div></div><div class="text-center py-4 border-t border-gray-800"><p class="text-sm mb-2"> &copy; 2025 Imators. جميع الحقوق محفوظة. </p><p class="text-xs"> Imators هي شركة ذات مسؤولية محدودة (LLC). جميع منتجاتنا، سواء كانت ماديًا تقنيًا أو متوفرة عبر الإنترنت فقط، تخضع لقواعدنا التي يمكنكم الوصول إليها. </p></div></footer>

<script>
    // FAQ functionality
    document.querySelectorAll('.faq-question').forEach(question => {
        question.addEventListener('click', () => {
            const answer = question.nextElementSibling;
            const arrow = question.querySelector('svg');
            const isActive = answer.classList.contains('active');

            // Close all answers
            document.querySelectorAll('.faq-answer').forEach(a => {
                a.classList.remove('active');
            });
            document.querySelectorAll('.faq-question svg').forEach(svg => {
                svg.style.transform = 'rotate(0deg)';
            });

            // Toggle clicked answer
            if (!isActive) {
                answer.classList.add('active');
                arrow.style.transform = 'rotate(180deg)';
            }
        });
    });
</script>
</body>
</html>