<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Choose Language - Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500&display=swap');

        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #000000 0%, #1a1a1a 100%);
            color: #FFFFFF;
            min-height: 100vh;
        }

        .animate-fade {
            opacity: 0;
            transform: translateY(20px);
            transition: all 0.8s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .animate-fade.visible {
            opacity: 1;
            transform: translateY(0);
        }

        .btn {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .btn:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
        }

        .btn:active {
            transform: translateY(0);
        }
    </style>
</head>
<body class="flex items-center justify-center p-4">
    <main class="text-center">
        <div class="mb-12">
            <img src="https://cdn.imators.com/logo.png" alt="Imators" class="h-8 mx-auto mb-8 animate-fade visible">
        </div>

        <div class="mb-16 min-h-[60px] flex items-center justify-center">
            <h1 id="welcomeText" class="text-4xl font-light animate-fade"></h1>
        </div>

        <div class="mb-16 min-h-[48px] flex items-center justify-center">
            <p id="descText" class="text-lg font-light animate-fade text-gray-400 max-w-md"></p>
        </div>

        <div class="flex gap-6 justify-center">
            <a href="" id="langBtn1" class="btn text-white px-10 py-4 rounded-full font-light text-lg"></a>
            <a href="" id="langBtn2" class="btn text-white px-10 py-4 rounded-full font-light text-lg"></a>
        </div>
    </main>

    <script>
        const urlParams = new URLSearchParams(window.location.search);
        const redirect = urlParams.get('redirect');

        let welcomeTexts = [];
        let descTexts = [];
        let currentText = 0;

        const setupLanguages = (lang1, lang2) => {
            document.getElementById('langBtn1').textContent = lang1;
            document.getElementById('langBtn2').textContent = lang2;
            document.getElementById('langBtn1').href = `/${lang1.toLowerCase()}`;
            document.getElementById('langBtn2').href = `/${lang2.toLowerCase()}`;
        };

        switch(redirect) {
            case 'be':
                welcomeTexts = ['Bienvenue', 'Welkom'];
                descTexts = ['Choisissez votre langue préférée', 'Kies uw voorkeurstaal'];
                setupLanguages('FR', 'NL');
                break;
            case 'ar':
                welcomeTexts = ['Welcome', 'مرحباً'];
                descTexts = ['Choose your preferred language', 'اختر لغتك المفضلة'];
                setupLanguages('EN', 'AR');
                break;
            case 'ch':
                welcomeTexts = ['Willkommen', 'Bienvenue'];
                descTexts = ['Wählen Sie Ihre bevorzugte Sprache', 'Choisissez votre langue préférée'];
                setupLanguages('DE', 'FR');
                break;
            default:
                welcomeTexts = ['Welcome', 'Bienvenue'];
                descTexts = ['Choose your preferred language', 'Choisissez votre langue préférée'];
                setupLanguages('EN', 'FR');
        }

        const welcomeText = document.getElementById('welcomeText');
        const descText = document.getElementById('descText');

        const animateTexts = () => {
            welcomeText.classList.remove('visible');
            descText.classList.remove('visible');
            
            setTimeout(() => {
                welcomeText.textContent = welcomeTexts[currentText];
                descText.textContent = descTexts[currentText];
                welcomeText.classList.add('visible');
                descText.classList.add('visible');
                currentText = (currentText + 1) % welcomeTexts.length;
            }, 800);
        };

        animateTexts();
        setInterval(animateTexts, 3000);
    </script>
</body>
</html>