<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>uOS - A New Operating System Experience</title>
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- GSAP Animation Library -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.5/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.5/ScrollTrigger.min.js"></script>
    <!-- Custom Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #0f0f0f;
            color: #f5f5f5;
            overflow-x: hidden;
        }
        .gradient-text {
            background: linear-gradient(90deg, #3b82f6, #06b6d4);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        .hero-section {
            background: radial-gradient(circle at center, #1a1a1a 0%, #0f0f0f 100%);
        }
        .feature-card {
            backdrop-filter: blur(12px);
            background-color: rgba(30, 30, 30, 0.5);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
    </style>
</head>
<body>
    <?php
    // PHP variables for dynamic content
    $releaseDate = "25 June 2025";
    $betaVersion = "0.9.8";
    $features = [
        [
            "title" => "Home Mode",
            "description" => "Optimised for everyday computing with a focus on simplicity and efficiency."
        ],
        [
            "title" => "Hosting Machine",
            "description" => "Preconfigured for server operations with enhanced performance capabilities."
        ],
        [
            "title" => "Professional",
            "description" => "Tailored for business environments with advanced productivity tools."
        ],
        [
            "title" => "Shield Mode",
            "description" => "Transform your system into a database or radio signal transmitter, rendering the interface permanently inaccessible."
        ]
    ];
    ?>

        <?php include 'src/header.php'; ?>

    <!-- Hero Section -->
    <section class="hero-section min-h-screen flex items-center justify-center pt-20">
        <div class="container mx-auto px-6 py-16 text-center">
            <div class="mb-12 reveal-text">
                <h1 class="text-6xl md:text-8xl font-light mb-2 gradient-text tracking-tighter">u<span class="font-bold">OS</span></h1>
                <p class="text-xl text-gray-400 max-w-2xl mx-auto">A lightweight, secure Linux-based operating system for the future</p>
            </div>
            
            <div class="mb-2 mx-auto max-w-4xl reveal-image">
                <img src="/api/placeholder/1200/675" alt="uOS Interface" class="w-full rounded-lg shadow-2xl border border-gray-800">
            </div>
            
            <p class="text-xs text-gray-500 mb-8">Beta Version <?php echo $betaVersion; ?></p>
            
            <div class="flex flex-col sm:flex-row justify-center gap-4 reveal-buttons">
                <a href="#download" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded-md font-medium transition-colors">Get Early Access</a>
                <a href="#features" class="bg-transparent border border-gray-600 hover:border-gray-400 text-gray-300 hover:text-white px-6 py-3 rounded-md font-medium transition-colors">Learn More</a>
            </div>
            
            <div class="mt-12 text-gray-500 reveal-date">
                <p>Official Release: <?php echo $releaseDate; ?></p>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section id="features" class="py-20 bg-black">
        <div class="container mx-auto px-6">
            <h2 class="text-4xl font-bold mb-12 text-center gradient-text feature-title">Adaptive Modes for Every Need</h2>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <?php foreach($features as $index => $feature): ?>
                <div class="feature-card p-8 rounded-lg feature-item" data-index="<?php echo $index; ?>">
                    <h3 class="text-2xl font-bold mb-4"><?php echo $feature["title"]; ?></h3>
                    <p class="text-gray-400"><?php echo $feature["description"]; ?></p>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- Security Section -->
    <section id="security" class="py-20 bg-gradient-to-b from-black to-gray-900">
        <div class="container mx-auto px-6">
            <div class="flex flex-col md:flex-row items-center gap-12">
                <div class="md:w-1/2 security-text">
                    <h2 class="text-4xl font-bold mb-6 gradient-text">Built-in Privacy Protection</h2>
                    <p class="text-gray-300 mb-6">uOS is automatically secured with TOR network or Cloudflare integration, ensuring your privacy is protected at all times.</p>
                    <ul class="space-y-4">
                        <li class="flex items-start">
                            <svg class="w-6 h-6 text-blue-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                            <span class="text-gray-400">End-to-end encryption for all communications</span>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-6 h-6 text-blue-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                            <span class="text-gray-400">Anonymous browsing via integrated TOR network</span>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-6 h-6 text-blue-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                            <span class="text-gray-400">DDoS protection with Cloudflare integration</span>
                        </li>
                    </ul>
                </div>
                <div class="md:w-1/2 security-image">
                    <img src="/api/placeholder/600/400" alt="uOS Security Features" class="w-full rounded-lg shadow-2xl border border-gray-800">
                </div>
            </div>
        </div>
    </section>

    <!-- Download Section -->
    <section id="download" class="py-20 bg-gray-900">
        <div class="container mx-auto px-6 text-center">
            <h2 class="text-4xl font-bold mb-6 gradient-text download-title">Get Ready for uOS</h2>
            <p class="text-gray-300 mb-12 max-w-2xl mx-auto download-text">uOS will be available as an ISO download starting <?php echo $releaseDate; ?>. Experience a new generation of operating systems.</p>
            
            <div class="bg-gray-800 p-8 rounded-lg max-w-2xl mx-auto download-box">
                <h3 class="text-2xl font-bold mb-4">System Requirements</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-left mb-8">
                    <div>
                        <p class="text-gray-400 mb-2">CPU: 64-bit dual-core or better</p>
                        <p class="text-gray-400 mb-2">RAM: 4GB minimum</p>
                        <p class="text-gray-400">Storage: 20GB free space</p>
                    </div>
                    <div>
                        <p class="text-gray-400 mb-2">Graphics: OpenGL 3.3 compatible</p>
                        <p class="text-gray-400 mb-2">Network: Internet connection</p>
                        <p class="text-gray-400">USB: 8GB+ for installation media</p>
                    </div>
                </div>
                
                <button class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded-md font-medium transition-colors w-full md:w-auto">Join Waiting List</button>
            </div>
        </div>
    </section>

    <!-- Promo Banner -->
    <section class="py-10 bg-blue-900 promo-banner">
        <div class="container mx-auto px-6 text-center">
            <h3 class="text-2xl font-bold mb-4">Stay Informed About the Launch</h3>
            <p class="text-gray-300 mb-6">To be notified when uOS is released, create an Imators account today.</p>
            <button class="bg-white text-blue-900 hover:bg-gray-200 px-6 py-3 rounded-md font-medium transition-colors">Create Imators Account</button>
        </div>
    </section>

    <!-- Footer -->
    <footer class="py-8 bg-black border-t border-gray-800"><div class="max-w-6xl mx-auto px-4 py-6 flex flex-wrap justify-between">
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Need Help?</h5>
        <a href="/support" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Support
        </a>
        <a href="/contact-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Contact Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Discover</h5>
        <a href="/privacy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Privacy Policy
        </a>
        <a href="/terms-of-use" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Terms of Use
        </a>
        <a href="/refund-policy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Refund Policy
        </a>
        <a href="/legal-notice" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Legal Notice
        </a>
        <a href="/" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Home
        </a>
        <a href="/about-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            About Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Because it's possible</h5>
        <p class="text-sm">
            All images, videos, and content on this site are the property of Imators.
        </p>
    </div>
</div>

<div class="text-center py-3 border-t border-gray-800">
    <p class="text-sm">
        &copy; <?php echo date("Y"); ?> Imators. All rights reserved.
    </p>
    <p class="text-xs mt-2">
        <a href="https://aktascorp.com">Imators is a aktascorp members.</a>
    </p>
    <p class="text-xs">
        Imators is a registered LLC. All our products are subject to our terms.
    </p>
</div></footer>

    <!-- GSAP Animations -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Register ScrollTrigger plugin
            gsap.registerPlugin(ScrollTrigger);
            
            // Hero section animations
            gsap.from('.reveal-text', {
                opacity: 0,
                y: 50,
                duration: 1,
                ease: 'power3.out'
            });
            
            gsap.from('.reveal-image', {
                opacity: 0,
                y: 30,
                duration: 1,
                delay: 0.3,
                ease: 'power3.out'
            });
            
            gsap.from('.reveal-buttons', {
                opacity: 0,
                y: 30,
                duration: 1,
                delay: 0.6,
                ease: 'power3.out'
            });
            
            gsap.from('.reveal-date', {
                opacity: 0,
                y: 20,
                duration: 1,
                delay: 0.8,
                ease: 'power3.out'
            });
            
            // Features section animations
            gsap.from('.feature-title', {
                scrollTrigger: {
                    trigger: '.feature-title',
                    start: 'top 80%'
                },
                opacity: 0,
                y: 30,
                duration: 0.8,
                ease: 'power3.out'
            });
            
            // Staggered animation for feature items
            gsap.from('.feature-item', {
                scrollTrigger: {
                    trigger: '.feature-item',
                    start: 'top 80%'
                },
                opacity: 0,
                y: 30,
                duration: 0.8,
                stagger: 0.2,
                ease: 'power3.out'
            });
            
            // Security section animations
            gsap.from('.security-text', {
                scrollTrigger: {
                    trigger: '.security-text',
                    start: 'top 80%'
                },
                opacity: 0,
                x: -50,
                duration: 0.8,
                ease: 'power3.out'
            });
            
            gsap.from('.security-image', {
                scrollTrigger: {
                    trigger: '.security-image',
                    start: 'top 80%'
                },
                opacity: 0,
                x: 50,
                duration: 0.8,
                ease: 'power3.out'
            });
            
            // Download section animations
            gsap.from('.download-title, .download-text', {
                scrollTrigger: {
                    trigger: '.download-title',
                    start: 'top 80%'
                },
                opacity: 0,
                y: 30,
                duration: 0.8,
                stagger: 0.2,
                ease: 'power3.out'
            });
            
            gsap.from('.download-box', {
                scrollTrigger: {
                    trigger: '.download-box',
                    start: 'top 80%'
                },
                opacity: 0,
                y: 30,
                duration: 0.8,
                delay: 0.2,
                ease: 'power3.out'
            });
            
            // Promo banner animation
            gsap.from('.promo-banner', {
                scrollTrigger: {
                    trigger: '.promo-banner',
                    start: 'top 90%'
                },
                opacity: 0,
                y: 20,
                duration: 0.8,
                ease: 'power3.out'
            });
        });
    </script>
</body>
</html>