<?php
include 'db.php';
header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);
$orderId = $input['orderId'];

$query = "SELECT status FROM orders WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $orderId);
$stmt->execute();
$result = $stmt->get_result()->fetch_assoc();

if ($result) {
    echo json_encode(['status' => $result['status']]);
} else {
    echo json_encode(['error' => 'Commande non trouvée']);
}
?>