<?php
include 'db.php';
session_start();

$error = '';
$success = '';
$valid_token = false;
$user_data = null;

if (!isset($_GET['token']) || empty($_GET['token'])) {
    $error = 'Lien de réinitialisation invalide';
} else {
    $token = $_GET['token'];
    
    $stmt = $conn->prepare("SELECT id, first_name, email, reset_expires FROM residents WHERE reset_token = ?");
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($user_data = $result->fetch_assoc()) {
        if (new DateTime($user_data['reset_expires']) > new DateTime()) {
            $valid_token = true;
        } else {
            $error = 'Ce lien de réinitialisation a expiré';
        }
    } else {
        $error = 'Ce lien de réinitialisation a expiré ou est invalide';
    }
}

if ($_POST && $valid_token) {
    $new_password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];
    
    if (empty($new_password) || empty($confirm_password)) {
        $error = 'Tous les champs sont requis';
    } elseif (strlen($new_password) < 6) {
        $error = 'Le mot de passe doit contenir au moins 6 caractères';
    } elseif ($new_password !== $confirm_password) {
        $error = 'Les mots de passe ne correspondent pas';
    } else {
        $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
        $remember_token = bin2hex(random_bytes(32));
        
        $stmt = $conn->prepare("UPDATE residents SET password = ?, reset_token = NULL, reset_expires = NULL, remember_token = ? WHERE id = ?");
        $stmt->bind_param("ssi", $hashed_password, $remember_token, $user_data['id']);
        
        if ($stmt->execute()) {
            $_SESSION['resident_id'] = $user_data['id'];
            $_SESSION['resident_name'] = $user_data['first_name'];
            
            $expires = time() + (365 * 24 * 60 * 60);
            setcookie('remember_token', $remember_token, $expires, '/', '', false, true);
            setcookie('resident_email', $user_data['email'], $expires, '/', '', false, false);
            
            $success = 'Mot de passe modifié avec succès ! Tu seras redirigé dans 3 secondes...';
            echo '<script>setTimeout(() => { window.location.href = "resident-dashboard.php"; }, 3000);</script>';
        } else {
            $error = 'Erreur lors de la modification du mot de passe';
        }
    }
}
?>

<!DOCTYPE html>

<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Réinitialiser le mot de passe - Vert Chasseur</title>
    <link rel="icon" type="image/png" href="logo_new.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {}
            }
        }
    </script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&display=swap" rel="stylesheet">
    <style>
        @media (min-width: 768px) {
            body {
                background-image: url('font-homepage.png');
                background-size: cover;
                background-position: center;
                background-attachment: fixed;
                background-repeat: no-repeat;
            }
        }
        @media (max-width: 767px) {
            body {
                background-color: #ffffff !important;
                background-image: none !important;
            }
            .dark body {
                background-color: #000000 !important;
                background-image: none !important;
            }
        }
        body {
            font-family: 'Inter', sans-serif;
        }
        .txt-chasseur {
            font-family: "Princess Sofia", serif;
            font-weight: 400;
        }
    </style>
</head>
<body class="bg-white dark:bg-black transition-colors duration-300">
    <script>
        if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
            document.documentElement.classList.add('dark');
        } else {
            document.documentElement.classList.remove('dark');
        }
    </script>

<div class="min-h-screen flex items-center justify-center p-4">
    <div class="w-full max-w-md">
        <div class="mb-8">
            <h1 class="text-4xl font-light text-stone-800 dark:text-white mb-2">
                Nouveau mot de passe
            </h1>
            <?php if ($valid_token && $user_data): ?>
            <p class="text-stone-600 dark:text-stone-400">Salutations <?= htmlspecialchars($user_data['first_name']) ?>, choisis ton nouveau mot de passe</p>
            <?php else: ?>
            <p class="text-stone-600 dark:text-stone-400">Réinitialisation du mot de passe</p>
            <?php endif; ?>
        </div>

    <?php if ($error): ?>
    <div class="mb-6 p-4 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-2xl">
        <p class="text-red-600 dark:text-red-400 text-sm"><?= htmlspecialchars($error) ?></p>
    </div>
    <?php endif; ?>
    
    <?php if ($success): ?>
    <div class="mb-6 p-4 bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-2xl">
        <p class="text-green-600 dark:text-green-400 text-sm"><?= htmlspecialchars($success) ?></p>
    </div>
    <?php endif; ?>

    <?php if ($valid_token): ?>
    <form method="POST" class="space-y-6">
        <input type="password" name="password" required minlength="6" placeholder="Nouveau mot de passe (min. 6 caractères)" 
               class="w-full px-6 py-4 rounded-2xl border border-stone-200 dark:border-stone-700 bg-white dark:bg-stone-900 text-stone-900 dark:text-white placeholder-stone-500 dark:placeholder-stone-400 focus:ring-2 focus:ring-stone-900 dark:focus:ring-white focus:border-transparent transition-all">
        
        <input type="password" name="confirm_password" required minlength="6" placeholder="Confirme ton nouveau mot de passe" 
               class="w-full px-6 py-4 rounded-2xl border border-stone-200 dark:border-stone-700 bg-white dark:bg-stone-900 text-stone-900 dark:text-white placeholder-stone-500 dark:placeholder-stone-400 focus:ring-2 focus:ring-stone-900 dark:focus:ring-white focus:border-transparent transition-all">
        
        <button type="submit" 
                class="w-full bg-stone-900 dark:bg-white text-white dark:text-black py-4 rounded-2xl font-medium hover:opacity-90 transition-all">
            Changer le mot de passe
        </button>
    </form>
    <?php endif; ?>

    <div class="mt-8 text-center">
        <a href="index.php" class="inline-flex items-center text-stone-600 dark:text-stone-400 hover:text-stone-800 dark:hover:text-stone-200 transition-colors text-sm mb-4">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
            </svg>
            Retour à la connexion
        </a>
        <div>
            <img src="logo_new.png" alt="Vert Chasseur" class="w-8 h-8 mx-auto opacity-50">
        </div>
    </div>
</div>

</div>

</body>
</html>