<?php
session_start();

if(!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

require_once 'db.php';
require_once 'gov/functions_loterie.php';

$user_id = $_SESSION['user_id'];

$sql = "SELECT * FROM users WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

$sql = "SELECT solde FROM comptes_bancaires WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$compte = $result->fetch_assoc();
$solde = $compte ? $compte['solde'] : 0;

$message = '';
$success = false;

if(isset($_POST['action']) && $_POST['action'] == 'participer') {
    $loterie_id = $_POST['loterie_id'];
    $numero_1 = $_POST['numero_1'];
    $numero_2 = $_POST['numero_2'];
    $numero_3 = $_POST['numero_3'];
    
    if(empty($numero_1) || empty($numero_2) || empty($numero_3)) {
        $message = "Tous les numéros doivent être sélectionnés.";
    } elseif($numero_1 < 1 || $numero_1 > 10 || $numero_2 < 1 || $numero_2 > 10 || $numero_3 < 1 || $numero_3 > 10) {
        $message = "Les numéros doivent être entre 1 et 10.";
    } elseif($numero_1 == $numero_2 || $numero_1 == $numero_3 || $numero_2 == $numero_3) {
        $message = "Les trois numéros doivent être différents.";
    } else {
        $sql = "SELECT * FROM loteries WHERE id = ? AND statut = 'ouvert' AND date_tirage > CURDATE()";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $loterie_id);
        $stmt->execute();
        $loterie = $stmt->get_result()->fetch_assoc();
        
        if(!$loterie) {
            $message = "Cette loterie n'est plus disponible.";
        } else {
            $sql = "SELECT id FROM loterie_participations WHERE loterie_id = ? AND user_id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ii", $loterie_id, $user_id);
            $stmt->execute();
            $participation_existante = $stmt->get_result()->fetch_assoc();
            
            if($participation_existante) {
                $message = "Vous avez déjà participé à cette loterie.";
            } elseif($solde < 50) {
                $message = "Solde insuffisant. Il vous faut 50 F& pour participer.";
            } else {
                $conn->begin_transaction();
                
                try {
                    $sql = "INSERT INTO loterie_participations (loterie_id, user_id, numero_1, numero_2, numero_3, prix_paye) VALUES (?, ?, ?, ?, ?, 50.00)";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("iiiii", $loterie_id, $user_id, $numero_1, $numero_2, $numero_3);
                    
                    if(!$stmt->execute()) {
                        throw new Exception("Erreur lors de l'enregistrement de la participation");
                    }
                    
                    $nouveau_solde = $solde - 50;
                    $sql = "UPDATE comptes_bancaires SET solde = ? WHERE user_id = ?";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("di", $nouveau_solde, $user_id);
                    
                    if(!$stmt->execute()) {
                        throw new Exception("Erreur lors du débit du compte");
                    }
                    
                    $sql = "SELECT user_id FROM identites WHERE code_transfert = '9TSEZL7R'";
                    $stmt = $conn->prepare($sql);
                    $stmt->execute();
                    $compte_frais = $stmt->get_result()->fetch_assoc();
                    
                    if($compte_frais) {
                        $sql = "UPDATE comptes_bancaires SET solde = solde + 50 WHERE user_id = ?";
                        $stmt = $conn->prepare($sql);
                        $stmt->bind_param("i", $compte_frais['user_id']);
                        $stmt->execute();
                    }
                    
                    $sql = "INSERT INTO transactions (user_id, destinataire_id, destinataire_nom, emetteur_nom, montant, motif) VALUES (?, 1, 'Loterie Peerkinton', ?, 50.00, 'Participation loterie - Numéros: " . $numero_1 . "-" . $numero_2 . "-" . $numero_3 . "')";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("is", $user_id, $user['email']);
                    $stmt->execute();
                    
                    $sql = "UPDATE loteries SET jackpot = jackpot + 40 WHERE id = ?";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("i", $loterie_id);
                    $stmt->execute();
                    
                    $conn->commit();
                    
                    $success = true;
                    $message = "Participation enregistrée avec succès ! Vos numéros : " . $numero_1 . "-" . $numero_2 . "-" . $numero_3 . ". Bonne chance !";
                    
                } catch (Exception $e) {
                    $conn->rollback();
                    $message = "Erreur lors de la participation : " . $e->getMessage();
                }
            }
        }
    }
}

$redirect_url = "dashboard.php?onglet=loterie";
if($message) {
    $redirect_url .= "&loterie_message=" . urlencode($message) . "&loterie_success=" . ($success ? '1' : '0');
}

header("Location: " . $redirect_url);
exit();
?>