import * as tailwind_variants from 'tailwind-variants';
import * as react from 'react';
import { ReactElement, ReactNode, Key } from 'react';
import * as _heroui_system from '@heroui/system';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system';
import { BreadcrumbsVariantProps, SlotsToClasses, BreadcrumbsSlots } from '@heroui/theme';
import { AriaBreadcrumbsProps } from '@react-types/breadcrumbs';
import { ReactRef } from '@heroui/react-utils';
import { BreadcrumbItemProps } from './breadcrumb-item.mjs';
import './use-breadcrumb-item.mjs';

type RenderEllipsisItemProps = {
    /**
     * The collapsed items.
     */
    items: BreadcrumbItemProps[];
    /**
     * The max number of items.
     */
    maxItems: number;
    /**
     * The picked item to render the ellipsis.
     */
    collapsedItem: ReactNode;
    /**
     * The default ellipsis icon.
     */
    ellipsisIcon: ReactNode;
    /**
     * Number of items to show before the ellipsis.
     */
    itemsBeforeCollapse: number;
    /**
     * Number of items to show after the ellipsis.
     */
    itemsAfterCollapse: number;
    /**
     * The separator between each breadcrumb. It is a chevron by default.
     */
    separator: ReactNode;
};
interface Props extends HTMLHeroUIProps<"nav">, AriaBreadcrumbsProps {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLElement | null>;
    /**
     * If max items is exceeded, the number of items to show before the ellipsis.
     * @default 1
     */
    itemsBeforeCollapse?: number;
    /**
     * If max items is exceeded, the number of items to show after the ellipsis.
     * @default 2
     */
    itemsAfterCollapse?: number;
    /**
     * Specifies the maximum number of breadcrumbs to display. When there are more
     * than the maximum number, only the first `itemsBeforeCollapse` and last `itemsAfterCollapse`
     * will be shown, with an ellipsis in between.
     * @default 8
     */
    maxItems?: number;
    /**
     * The separator between each breadcrumb. It is a chevron by default.
     */
    separator?: ReactNode;
    /**
     * Breadcrumbs in a disabled state shows items, but indicates that navigation is
     * not available. This can be used to maintain layout continuity.
     * @default false
     */
    isDisabled?: boolean;
    /**
     * The breadcrumbs classNames.
     */
    classNames?: SlotsToClasses<BreadcrumbsSlots>;
    /**
     * The breadcrumbs items classNames.
     */
    itemClasses?: BreadcrumbItemProps["classNames"];
    /**
     * A function that allows to render the ellipsis when the number of items is exceeded.
     *
     * @param props RenderEllipsisItemProps
     */
    renderEllipsis?: (props: RenderEllipsisItemProps) => ReactNode;
    /**
     * Callback when any of the breadcrumbs is pressed.
     * @param key string
     */
    onAction?: (key: Key) => void;
}
type UseBreadcrumbsProps = Props & BreadcrumbsVariantProps & Partial<Pick<BreadcrumbItemProps, "color" | "size" | "underline" | "hideSeparator" | "disableAnimation">>;
declare function useBreadcrumbs(originalProps: UseBreadcrumbsProps): {
    Component: _heroui_system.As<any>;
    children: ReactElement<any, string | react.JSXElementConstructor<any>>[] | undefined;
    slots: {
        base: (slotProps?: ({
            size?: "md" | "sm" | "lg" | undefined;
            radius?: "md" | "sm" | "lg" | "none" | "full" | undefined;
            variant?: "light" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        list: (slotProps?: ({
            size?: "md" | "sm" | "lg" | undefined;
            radius?: "md" | "sm" | "lg" | "none" | "full" | undefined;
            variant?: "light" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        ellipsis: (slotProps?: ({
            size?: "md" | "sm" | "lg" | undefined;
            radius?: "md" | "sm" | "lg" | "none" | "full" | undefined;
            variant?: "light" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        separator: (slotProps?: ({
            size?: "md" | "sm" | "lg" | undefined;
            radius?: "md" | "sm" | "lg" | "none" | "full" | undefined;
            variant?: "light" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {
        base: (slotProps?: ({
            size?: "md" | "sm" | "lg" | undefined;
            radius?: "md" | "sm" | "lg" | "none" | "full" | undefined;
            variant?: "light" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        list: (slotProps?: ({
            size?: "md" | "sm" | "lg" | undefined;
            radius?: "md" | "sm" | "lg" | "none" | "full" | undefined;
            variant?: "light" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        ellipsis: (slotProps?: ({
            size?: "md" | "sm" | "lg" | undefined;
            radius?: "md" | "sm" | "lg" | "none" | "full" | undefined;
            variant?: "light" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        separator: (slotProps?: ({
            size?: "md" | "sm" | "lg" | undefined;
            radius?: "md" | "sm" | "lg" | "none" | "full" | undefined;
            variant?: "light" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {};
    separator: ReactNode;
    childCount: number;
    itemsAfterCollapse: number;
    itemsBeforeCollapse: number;
    maxItems: number;
    classNames: SlotsToClasses<"base" | "list" | "ellipsis" | "separator"> | undefined;
    isDisabled: boolean | undefined;
    itemProps: Partial<BreadcrumbItemProps>;
    renderEllipsis: ((props: RenderEllipsisItemProps) => ReactNode) | undefined;
    getBaseProps: PropGetter;
    getListProps: () => {
        "data-slot": string;
        className: string;
    };
    getEllipsisProps: () => {
        "data-slot": string;
        className: string;
    };
    getSeparatorProps: () => {
        "data-slot": string;
        "aria-hidden": boolean | "true" | "false";
        className: string;
    };
    onAction: ((key: Key) => void) | undefined;
};
type UseBreadcrumbsReturn = ReturnType<typeof useBreadcrumbs>;

export { type UseBreadcrumbsProps, type UseBreadcrumbsReturn, useBreadcrumbs };
