"use client";
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/dropdown.tsx
var dropdown_exports = {};
__export(dropdown_exports, {
  default: () => dropdown_default
});
module.exports = __toCommonJS(dropdown_exports);
var import_react2 = __toESM(require("react"));
var import_popover = require("@heroui/popover");

// src/dropdown-context.ts
var import_react_utils = require("@heroui/react-utils");
var [DropdownProvider, useDropdownContext] = (0, import_react_utils.createContext)({
  name: "DropdownContext",
  errorMessage: "useDropdownContext: `context` is undefined. Seems you forgot to wrap all popover components within `<Dropdown />`"
});

// src/use-dropdown.ts
var import_system = require("@heroui/system");
var import_menu = require("@react-stately/menu");
var import_menu2 = require("@react-aria/menu");
var import_theme = require("@heroui/theme");
var import_shared_utils = require("@heroui/shared-utils");
var import_react_utils2 = require("@heroui/react-utils");
var import_aria_utils = require("@heroui/aria-utils");
var import_react = require("react");
var import_utils = require("@react-aria/utils");
var getMenuItem = (props, key) => {
  if (props) {
    const mergedChildren = Array.isArray(props.children) ? props.children : [...(props == null ? void 0 : props.items) || []];
    if (mergedChildren && mergedChildren.length) {
      const item = mergedChildren.find((item2) => {
        if (item2 && item2.key === key) {
          return item2;
        }
      }) || {};
      return item;
    }
  }
  return null;
};
var getCloseOnSelect = (props, key, item) => {
  const mergedItem = item || getMenuItem(props, key);
  if (mergedItem && mergedItem.props && "closeOnSelect" in mergedItem.props) {
    return mergedItem.props.closeOnSelect;
  }
  return props == null ? void 0 : props.closeOnSelect;
};
function useDropdown(props) {
  var _a;
  const globalContext = (0, import_system.useProviderContext)();
  const {
    as,
    triggerRef: triggerRefProp,
    isOpen,
    defaultOpen,
    onOpenChange,
    isDisabled,
    type = "menu",
    trigger = "press",
    placement = "bottom",
    closeOnSelect = true,
    shouldBlockScroll = true,
    classNames: classNamesProp,
    disableAnimation = (_a = globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _a : false,
    onClose,
    className,
    ...otherProps
  } = props;
  const Component = as || "div";
  const triggerRef = (0, import_react.useRef)(null);
  const menuTriggerRef = triggerRefProp || triggerRef;
  const menuRef = (0, import_react.useRef)(null);
  const popoverRef = (0, import_react.useRef)(null);
  const state = (0, import_menu.useMenuTriggerState)({
    trigger,
    isOpen,
    defaultOpen,
    onOpenChange: (isOpen2) => {
      onOpenChange == null ? void 0 : onOpenChange(isOpen2);
      if (!isOpen2) {
        onClose == null ? void 0 : onClose();
      }
    }
  });
  const { menuTriggerProps, menuProps } = (0, import_menu2.useMenuTrigger)(
    { type, trigger, isDisabled },
    state,
    menuTriggerRef
  );
  const styles = (0, import_react.useMemo)(
    () => (0, import_theme.dropdown)({
      className
    }),
    [className]
  );
  const onMenuAction = (menuCloseOnSelect) => {
    if (menuCloseOnSelect !== void 0 && !menuCloseOnSelect) {
      return;
    }
    if (closeOnSelect) {
      state.close();
    }
  };
  const getPopoverProps = (props2 = {}) => {
    const popoverProps = (0, import_utils.mergeProps)(otherProps, props2);
    return {
      state,
      placement,
      ref: popoverRef,
      disableAnimation,
      shouldBlockScroll,
      scrollRef: menuRef,
      triggerRef: menuTriggerRef,
      ...popoverProps,
      classNames: {
        ...classNamesProp,
        ...props2.classNames,
        content: (0, import_shared_utils.clsx)(styles, classNamesProp == null ? void 0 : classNamesProp.content, props2.className)
      },
      shouldCloseOnInteractOutside: (popoverProps == null ? void 0 : popoverProps.shouldCloseOnInteractOutside) ? popoverProps.shouldCloseOnInteractOutside : (element) => (0, import_aria_utils.ariaShouldCloseOnInteractOutside)(element, triggerRef, state)
    };
  };
  const getMenuTriggerProps = (originalProps = {}) => {
    const { onPress, onPressStart, ...otherMenuTriggerProps } = menuTriggerProps;
    return (0, import_utils.mergeProps)(otherMenuTriggerProps, { isDisabled }, originalProps);
  };
  const getMenuProps = (props2, _ref = null) => {
    return {
      ref: (0, import_react_utils2.mergeRefs)(_ref, menuRef),
      menuProps,
      closeOnSelect,
      ...(0, import_utils.mergeProps)(props2, {
        onAction: (key, item) => {
          const closeOnSelect2 = getCloseOnSelect(props2, key, item);
          onMenuAction(closeOnSelect2);
        },
        onClose: state.close
      })
    };
  };
  return {
    Component,
    menuRef,
    menuProps,
    closeOnSelect,
    onClose: state.close,
    autoFocus: state.focusStrategy || true,
    disableAnimation,
    getPopoverProps,
    getMenuProps,
    getMenuTriggerProps
  };
}

// src/dropdown.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var Dropdown = (props) => {
  const { children, ...otherProps } = props;
  const context = useDropdown(otherProps);
  const [menuTrigger, menu] = import_react2.default.Children.toArray(children);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(DropdownProvider, { value: context, children: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_popover.Popover, { ...context.getPopoverProps(), children: [
    menuTrigger,
    menu
  ] }) });
};
Dropdown.displayName = "HeroUI.Dropdown";
var dropdown_default = Dropdown;
