import * as react from 'react';
import { Ref } from 'react';
import * as _heroui_system from '@heroui/system';
import { HTMLHeroUIProps, PropGetter } from '@heroui/system';
import { InputVariantProps, SlotsToClasses, InputSlots } from '@heroui/theme';
import { AriaTextFieldProps } from '@react-types/textfield';

interface Props<T extends HTMLInputElement | HTMLTextAreaElement = HTMLInputElement> extends Omit<HTMLHeroUIProps<"input">, keyof InputVariantProps> {
    /**
     * Ref to the DOM node.
     */
    ref?: Ref<T>;
    /**
     * Ref to the container DOM node.
     */
    baseRef?: Ref<HTMLDivElement>;
    /**
     * Ref to the input wrapper DOM node.
     * This is the element that wraps the input label and the innerWrapper when the labelPlacement="inside"
     * and the input has start/end content.
     */
    wrapperRef?: Ref<HTMLDivElement>;
    /**
     * Ref to the input inner wrapper DOM node.
     * This is the element that wraps the input and the start/end content when passed.
     */
    innerWrapperRef?: Ref<HTMLDivElement>;
    /**
     * Element to be rendered in the left side of the input.
     */
    startContent?: React.ReactNode;
    /**
     * Element to be rendered in the right side of the input.
     * if you pass this prop and the `onClear` prop, the passed element
     * will have the clear button props and it will be rendered instead of the
     * default clear button.
     */
    endContent?: React.ReactNode;
    /**
     * Classname or List of classes to change the classNames of the element.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     * <Input classNames={{
     *    base:"base-classes",
     *    label: "label-classes",
     *    mainWrapper: "main-wrapper-classes",
     *    inputWrapper: "input-wrapper-classes",
     *    innerWrapper: "inner-wrapper-classes",
     *    input: "input-classes",
     *    clearButton: "clear-button-classes",
     *    helperWrapper: "helper-wrapper-classes",
     *    description: "description-classes",
     *    errorMessage: "error-message-classes",
     * }} />
     * ```
     */
    classNames?: SlotsToClasses<InputSlots>;
    /**
     * Callback fired when the value is cleared.
     * if you pass this prop, the clear button will be shown.
     */
    onClear?: () => void;
    /**
     * React aria onChange event.
     */
    onValueChange?: (value: string) => void;
}
type UseInputProps<T extends HTMLInputElement | HTMLTextAreaElement = HTMLInputElement> = Props<T> & Omit<AriaTextFieldProps, "onChange"> & InputVariantProps;
declare function useInput<T extends HTMLInputElement | HTMLTextAreaElement = HTMLInputElement>(originalProps: UseInputProps<T>): {
    Component: _heroui_system.As<any>;
    classNames: SlotsToClasses<"label" | "base" | "input" | "description" | "errorMessage" | "helperWrapper" | "mainWrapper" | "inputWrapper" | "innerWrapper" | "clearButton"> | undefined;
    domRef: react.RefObject<T>;
    label: react.ReactNode;
    description: react.ReactNode;
    startContent: react.ReactNode;
    endContent: react.ReactNode;
    labelPlacement: "inside" | "outside" | "outside-left";
    isClearable: boolean | undefined;
    hasHelper: boolean;
    hasStartContent: boolean;
    isLabelOutside: boolean;
    isOutsideLeft: boolean;
    isLabelOutsideAsPlaceholder: boolean;
    shouldLabelBeOutside: boolean;
    shouldLabelBeInside: boolean;
    hasPlaceholder: boolean;
    isInvalid: boolean;
    errorMessage: react.ReactNode;
    getBaseProps: PropGetter;
    getLabelProps: PropGetter;
    getInputProps: PropGetter;
    getMainWrapperProps: PropGetter;
    getInputWrapperProps: PropGetter;
    getInnerWrapperProps: PropGetter;
    getHelperWrapperProps: PropGetter;
    getDescriptionProps: PropGetter;
    getErrorMessageProps: PropGetter;
    getClearButtonProps: PropGetter;
};
type UseInputReturn = ReturnType<typeof useInput>;

export { type Props, type UseInputProps, type UseInputReturn, useInput };
