"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/common/functions.ts
var functions_exports = {};
__export(functions_exports, {
  callAll: () => callAll,
  callAllHandlers: () => callAllHandlers,
  capitalize: () => capitalize,
  debounce: () => debounce,
  extractProperty: () => extractProperty,
  get: () => get,
  getUniqueID: () => getUniqueID,
  intersectionBy: () => intersectionBy,
  kebabCase: () => kebabCase,
  mapKeys: () => mapKeys,
  objectToDeps: () => objectToDeps,
  omit: () => omit,
  removeEvents: () => removeEvents,
  uniqBy: () => uniqBy
});
module.exports = __toCommonJS(functions_exports);
var capitalize = (s) => {
  return s ? s.charAt(0).toUpperCase() + s.slice(1).toLowerCase() : "";
};
function callAllHandlers(...fns) {
  return function func(event) {
    fns.some((fn) => {
      fn == null ? void 0 : fn(event);
      return event == null ? void 0 : event.defaultPrevented;
    });
  };
}
function callAll(...fns) {
  return function mergedFn(arg) {
    fns.forEach((fn) => {
      fn == null ? void 0 : fn(arg);
    });
  };
}
function extractProperty(key, defaultValue, ...objs) {
  let result = defaultValue;
  for (const obj of objs) {
    if (obj && key in obj && !!obj[key]) {
      result = obj[key];
    }
  }
  return result;
}
function getUniqueID(prefix) {
  return `${prefix}-${Math.floor(Math.random() * 1e6)}`;
}
function removeEvents(input) {
  for (const key in input) {
    if (key.startsWith("on")) {
      delete input[key];
    }
  }
  return input;
}
function objectToDeps(obj) {
  if (!obj || typeof obj !== "object") {
    return "";
  }
  try {
    return JSON.stringify(obj);
  } catch (e) {
    return "";
  }
}
function debounce(func, waitMilliseconds = 0) {
  let timeout;
  return function(...args) {
    const later = () => {
      timeout = void 0;
      func.apply(this, args);
    };
    if (timeout !== void 0) {
      clearTimeout(timeout);
    }
    timeout = setTimeout(later, waitMilliseconds);
  };
}
function uniqBy(arr, iteratee) {
  if (typeof iteratee === "string") {
    iteratee = (item) => item[iteratee];
  }
  return arr.filter((x, i, self) => i === self.findIndex((y) => iteratee(x) === iteratee(y)));
}
var omit = (obj, keys) => {
  const res = Object.assign({}, obj);
  keys.forEach((key) => {
    delete res[key];
  });
  return res;
};
var kebabCase = (s) => {
  return s.replace(/([a-z])([A-Z])/g, "$1-$2").toLowerCase();
};
var mapKeys = (obj, iteratee) => {
  return Object.fromEntries(
    Object.entries(obj).map(([key, value]) => [iteratee(value, key), value])
  );
};
var get = (object, path, defaultValue) => {
  const keys = Array.isArray(path) ? path : path.replace(/\[(\d+)\]/g, ".$1").split(".");
  let res = object;
  for (const key of keys) {
    res = res == null ? void 0 : res[key];
    if (res === void 0) {
      return defaultValue;
    }
  }
  return res;
};
var intersectionBy = (...args) => {
  if (args.length < 2) {
    throw new Error("intersectionBy requires at least two arrays and an iteratee");
  }
  const iteratee = args[args.length - 1];
  const arrays = args.slice(0, -1);
  if (arrays.length === 0) {
    return [];
  }
  const getIterateeValue = (item) => {
    if (typeof iteratee === "function") {
      return iteratee(item);
    } else if (typeof iteratee === "string") {
      return item[iteratee];
    } else {
      throw new Error("Iteratee must be a function or a string key of the array elements");
    }
  };
  const [first, ...rest] = arrays;
  const transformedFirst = first.map((item) => getIterateeValue(item));
  const transformedSets = rest.map(
    (array) => new Set(array.map((item) => getIterateeValue(item)))
  );
  const res = [];
  const seen = /* @__PURE__ */ new Set();
  for (let i = 0; i < first.length; i++) {
    const item = first[i];
    const transformed = transformedFirst[i];
    if (seen.has(transformed)) {
      continue;
    }
    const existsInAll = transformedSets.every((set) => set.has(transformed));
    if (existsInAll) {
      res.push(item);
      seen.add(transformed);
    }
  }
  return res;
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  callAll,
  callAllHandlers,
  capitalize,
  debounce,
  extractProperty,
  get,
  getUniqueID,
  intersectionBy,
  kebabCase,
  mapKeys,
  objectToDeps,
  omit,
  removeEvents,
  uniqBy
});
