"use client";

// src/use-toast.ts
import { mapPropsVariants, useProviderContext } from "@heroui/system";
import { toast as toastTheme } from "@heroui/theme";
import { useDOMRef } from "@heroui/react-utils";
import { clsx, dataAttr, isEmpty, objectToDeps } from "@heroui/shared-utils";
import { useCallback, useEffect, useLayoutEffect, useMemo, useRef, useState } from "react";
import { useToast as useToastAria } from "@react-aria/toast";
import { chain, mergeProps } from "@react-aria/utils";
import { useHover } from "@react-aria/interactions";
import { useIsMobile } from "@heroui/use-is-mobile";
var SWIPE_THRESHOLD_X = 100;
var SWIPE_THRESHOLD_Y = 20;
var INITIAL_POSITION = 50;
function useToast(originalProps) {
  var _a, _b;
  const [props, variantProps] = mapPropsVariants(originalProps, toastTheme.variantKeys);
  const {
    ref,
    as,
    title,
    description,
    className,
    classNames,
    toast,
    endContent,
    closeIcon,
    hideIcon = false,
    placement: placementProp = "bottom-right",
    isRegionExpanded,
    hideCloseButton = false,
    state,
    total = 1,
    index = 0,
    heights,
    promise: promiseProp,
    setHeights,
    toastOffset = 0,
    motionProps,
    timeout = 6e3,
    shouldShowTimeoutProgress = false,
    icon,
    onClose,
    severity,
    maxVisibleToasts,
    ...otherProps
  } = props;
  const { isHovered: isToastHovered, hoverProps } = useHover({
    isDisabled: false
  });
  const globalContext = useProviderContext();
  const disableAnimation = (_b = (_a = originalProps == null ? void 0 : originalProps.disableAnimation) != null ? _a : globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _b : false;
  const isMobile = useIsMobile();
  let placement = placementProp;
  if (isMobile) {
    if (placementProp.includes("top")) {
      placement = "top-center";
    } else {
      placement = "bottom-center";
    }
  }
  const animationRef = useRef(null);
  const startTime = useRef(null);
  const progressRef = useRef(0);
  const progressBarRef = useRef(null);
  const pausedTime = useRef(0);
  const timeElapsed = useRef(0);
  useEffect(() => {
    if (progressBarRef.current) {
      progressBarRef.current.style.width = "0%";
    }
  }, []);
  const [isLoading, setIsLoading] = useState(!!promiseProp);
  useEffect(() => {
    if (!promiseProp) return;
    promiseProp.finally(() => {
      setIsLoading(false);
    });
  }, [promiseProp]);
  useEffect(() => {
    const updateProgress = (timestamp) => {
      if (!timeout || isLoading) {
        return;
      }
      if (startTime.current === null) {
        startTime.current = timestamp;
      }
      if (isToastHovered || isRegionExpanded || index != total - 1) {
        pausedTime.current += timestamp - startTime.current;
        startTime.current = null;
        animationRef.current = requestAnimationFrame(updateProgress);
        return;
      }
      const elapsed = timestamp - startTime.current + pausedTime.current;
      timeElapsed.current = elapsed;
      if (timeElapsed.current >= timeout) {
        state.close(toast.key);
      }
      progressRef.current = Math.min(elapsed / timeout * 100, 100);
      if (progressBarRef.current) {
        progressBarRef.current.style.width = `${shouldShowTimeoutProgress ? progressRef.current : 0}%`;
      }
      if (progressRef.current < 100) {
        animationRef.current = requestAnimationFrame(updateProgress);
      }
    };
    animationRef.current = requestAnimationFrame(updateProgress);
    return () => {
      if (animationRef.current !== null) {
        cancelAnimationFrame(animationRef.current);
      }
    };
  }, [
    timeout,
    shouldShowTimeoutProgress,
    state,
    isToastHovered,
    index,
    total,
    isRegionExpanded,
    isLoading
  ]);
  const Component = as || "div";
  const loadingIcon = icon;
  const domRef = useDOMRef(ref);
  const baseStyles = clsx(className, classNames == null ? void 0 : classNames.base);
  const { toastProps, contentProps, titleProps, descriptionProps } = useToastAria(
    props,
    state,
    domRef
  );
  const [mounted, setMounted] = useState(false);
  useEffect(() => {
    setMounted(true);
  }, []);
  const [initialHeight, setInitialHeight] = useState(0);
  const [isToastExiting, setIsToastExiting] = useState(false);
  useLayoutEffect(() => {
    if (!domRef.current || !mounted || isToastExiting) {
      return;
    }
    const toastNode = domRef.current;
    const originalHeight = toastNode.style.height;
    toastNode.style.height = "auto";
    const computedStyle = getComputedStyle(toastNode);
    const marginTop = parseFloat(computedStyle.marginTop);
    const marginBottom = parseFloat(computedStyle.marginBottom);
    const newHeight = toastNode.getBoundingClientRect().height + marginTop + marginBottom;
    toastNode.style.height = originalHeight;
    setInitialHeight((prevHeight) => prevHeight !== newHeight ? newHeight : prevHeight);
    const updatedHeights = [...heights];
    if (updatedHeights.length > index) {
      updatedHeights[index] = newHeight;
    } else {
      updatedHeights.push(newHeight);
    }
    setHeights(updatedHeights);
  }, [mounted, total, setHeights, index, isToastExiting]);
  let liftHeight = 4;
  for (let idx = index + 1; idx < total; idx++) {
    liftHeight += heights[idx];
  }
  const frontHeight = heights[heights.length - 1];
  const slots = useMemo(
    () => toastTheme({
      ...variantProps,
      disableAnimation
    }),
    [objectToDeps(variantProps)]
  );
  const multiplier = placement.includes("top") ? 1 : -1;
  const toastVariants = {
    hidden: { opacity: 0, y: -INITIAL_POSITION * multiplier },
    visible: { opacity: 1, y: 0 },
    exit: { opacity: 0, y: -INITIAL_POSITION * multiplier }
  };
  const [drag, setDrag] = useState(false);
  const [dragValue, setDragValue] = useState(0);
  const shouldCloseToast = (offsetX, offsetY) => {
    const isRight = placement.includes("right");
    const isLeft = placement.includes("left");
    const isCenterTop = placement === "top-center";
    const isCenterBottom = placement === "bottom-center";
    if (isRight && offsetX >= SWIPE_THRESHOLD_X || isLeft && offsetX <= -SWIPE_THRESHOLD_X || isCenterTop && offsetY <= -SWIPE_THRESHOLD_Y || isCenterBottom && offsetY >= SWIPE_THRESHOLD_Y) {
      return true;
    }
  };
  const getDragElasticConstraints = (placement2) => {
    const elasticConstraint = { top: 0, bottom: 0, right: 0, left: 0 };
    if (placement2 === "bottom-center") {
      elasticConstraint.bottom = 1;
      return elasticConstraint;
    }
    if (placement2 === "top-center") {
      elasticConstraint.top = 1;
      return elasticConstraint;
    }
    if (placement2.includes("right")) {
      elasticConstraint.right = 1;
      return elasticConstraint;
    }
    if (placement2.includes("left")) {
      elasticConstraint.left = 1;
      return elasticConstraint;
    }
    elasticConstraint.left = 1;
    elasticConstraint.right = 1;
    return elasticConstraint;
  };
  let opacityValue = void 0;
  if (drag && placement === "bottom-center" || placement === "top-center") {
    opacityValue = Math.max(0, 1 - dragValue / (SWIPE_THRESHOLD_Y + 5));
  } else if (drag) {
    opacityValue = Math.max(0, 1 - dragValue / (SWIPE_THRESHOLD_X + 20));
  }
  const getToastProps = useCallback(
    (props2 = {}) => {
      const aboveToastHeight = index + 1 < total ? heights[index + 1] : 0;
      const belowToastHeight = index - 1 >= 0 ? heights[index - 1] : 0;
      const topExtension = aboveToastHeight ? Math.ceil(aboveToastHeight / 2) + 8 : 16;
      const bottomExtension = belowToastHeight ? Math.ceil(belowToastHeight / 2) + 8 : 16;
      const pseudoElementStyles = {
        "--top-extension": `${topExtension}px`,
        "--bottom-extension": `${bottomExtension}px`
      };
      return {
        ref: domRef,
        className: slots.base({ class: clsx(baseStyles, classNames == null ? void 0 : classNames.base) }),
        "data-has-title": dataAttr(!isEmpty(title)),
        "data-has-description": dataAttr(!isEmpty(description)),
        "data-placement": placement,
        "data-drag-value": dragValue,
        "data-toast": true,
        "aria-label": "toast",
        "data-toast-exiting": dataAttr(isToastExiting),
        onTransitionEnd: () => {
          if (isToastExiting) {
            const updatedHeights = heights;
            updatedHeights.splice(index, 1);
            setHeights([...updatedHeights]);
            state.close(toast.key);
          }
        },
        style: {
          opacity: opacityValue,
          ...pseudoElementStyles
        },
        ...mergeProps(props2, otherProps, toastProps, hoverProps)
      };
    },
    [
      slots,
      classNames,
      toastProps,
      hoverProps,
      toast,
      toast.key,
      opacityValue,
      isToastExiting,
      state,
      toast.key
    ]
  );
  const getWrapperProps = useCallback(
    (props2 = {}) => ({
      className: slots.wrapper({ class: classNames == null ? void 0 : classNames.wrapper }),
      ...props2
    }),
    []
  );
  const getIconProps = useCallback(
    (props2 = {}) => ({
      "aria-label": "descriptionIcon",
      className: slots.icon({ class: classNames == null ? void 0 : classNames.icon }),
      ...props2
    }),
    []
  );
  const getLoadingIconProps = useCallback(
    (props2 = {}) => ({
      className: slots.loadingIcon({ class: classNames == null ? void 0 : classNames.loadingIcon }),
      ...props2
    }),
    []
  );
  const getContentProps = useCallback(
    (props2 = {}) => ({
      className: slots.content({ class: classNames == null ? void 0 : classNames.content }),
      ...mergeProps(props2, otherProps, contentProps)
    }),
    [contentProps]
  );
  const getTitleProps = useCallback(
    (props2 = {}) => ({
      className: slots.title({ class: classNames == null ? void 0 : classNames.title }),
      ...mergeProps(props2, otherProps, titleProps)
    }),
    [titleProps]
  );
  const getDescriptionProps = useCallback(
    (props2 = {}) => ({
      className: slots.description({ class: classNames == null ? void 0 : classNames.description }),
      ...mergeProps(props2, otherProps, descriptionProps)
    }),
    [descriptionProps]
  );
  const getCloseButtonProps = useCallback(
    (props2 = {}) => ({
      className: slots.closeButton({ class: classNames == null ? void 0 : classNames.closeButton }),
      "aria-label": "closeButton",
      "data-hidden": dataAttr(hideCloseButton),
      ...mergeProps(props2, {
        onPress: chain(() => {
          setIsToastExiting(true);
          setTimeout(() => document.body.focus(), 0);
        }, onClose)
      })
    }),
    [setIsToastExiting, onClose, state, toast]
  );
  const getCloseIconProps = useCallback(
    (props2 = {}) => ({
      className: slots.closeIcon({ class: classNames == null ? void 0 : classNames.closeIcon }),
      "aria-label": "closeIcon",
      ...props2
    }),
    []
  );
  const getMotionDivProps = useCallback(
    (props2 = {}) => {
      const comparingValue = isRegionExpanded ? maxVisibleToasts - 1 : Math.min(2, maxVisibleToasts - 1);
      const isCloseToEnd = total - index - 1 <= comparingValue;
      const dragDirection = placement === "bottom-center" || placement === "top-center" ? "y" : "x";
      const dragConstraints = { left: 0, right: 0, top: 0, bottom: 0 };
      const dragElastic = getDragElasticConstraints(placement);
      const animateProps = (() => {
        if (placement.includes("top")) {
          return {
            top: isRegionExpanded || drag ? liftHeight + toastOffset : (total - 1 - index) * 8 + toastOffset,
            bottom: "auto"
          };
        } else if (placement.includes("bottom")) {
          return {
            bottom: isRegionExpanded || drag ? liftHeight + toastOffset : (total - 1 - index) * 8 + toastOffset,
            top: "auto"
          };
        }
        return {};
      })();
      return {
        animate: {
          opacity: isCloseToEnd ? 1 : 0,
          pointerEvents: isCloseToEnd ? "all" : "none",
          scaleX: isRegionExpanded || drag ? 1 : 1 - (total - 1 - index) * 0.1,
          height: isRegionExpanded || drag ? initialHeight : frontHeight,
          y: 0,
          ...animateProps
        },
        drag: dragDirection,
        dragConstraints,
        exit: { opacity: 0 },
        initial: { opacity: 0, scale: 1, y: -40 * multiplier },
        transition: { duration: 0.3, ease: "easeOut" },
        variants: toastVariants,
        dragElastic,
        onDragEnd: (_, info) => {
          const { x: offsetX, y: offsetY } = info.offset;
          setDrag(false);
          if (shouldCloseToast(offsetX, offsetY)) {
            const updatedHeights = heights;
            updatedHeights.splice(index, 1);
            setHeights([...updatedHeights]);
            state.close(toast.key);
            return;
          }
          setDragValue(0);
        },
        onDrag: (_, info) => {
          let updatedDragValue = 0;
          if (placement === "top-center") {
            updatedDragValue = -info.offset.y;
          } else if (placement === "bottom-center") {
            updatedDragValue = info.offset.y;
          } else if (placement.includes("right")) {
            updatedDragValue = info.offset.x;
          } else if (placement.includes("left")) {
            updatedDragValue = -info.offset.x;
          }
          if (updatedDragValue >= 0) {
            setDragValue(updatedDragValue);
          }
        },
        onDragStart: () => {
          setDrag(true);
        },
        "data-drag": dataAttr(drag),
        "data-placement": placement,
        "data-drag-value": dragValue,
        className: slots.motionDiv({ class: classNames == null ? void 0 : classNames.motionDiv }),
        ...props2,
        ...motionProps
      };
    },
    [
      total,
      index,
      placement,
      isRegionExpanded,
      isToastExiting,
      liftHeight,
      multiplier,
      initialHeight,
      frontHeight,
      toastVariants,
      classNames,
      drag,
      dataAttr,
      setDrag,
      shouldCloseToast,
      slots,
      toastOffset,
      maxVisibleToasts
    ]
  );
  return {
    Component,
    title,
    description,
    icon,
    loadingIcon,
    domRef,
    severity,
    closeIcon,
    classNames,
    color: variantProps["color"],
    hideIcon,
    placement,
    state,
    toast,
    disableAnimation,
    isProgressBarVisible: !!timeout,
    total,
    index,
    getWrapperProps,
    getToastProps,
    getTitleProps,
    getContentProps,
    getDescriptionProps,
    getCloseButtonProps,
    getIconProps,
    getMotionDivProps,
    getCloseIconProps,
    getLoadingIconProps,
    progressBarRef,
    endContent,
    slots,
    isRegionExpanded,
    liftHeight,
    frontHeight,
    initialHeight,
    isLoading
  };
}

export {
  useToast
};
