import * as react from 'react';
import { ReactNode } from 'react';
import * as _heroui_system from '@heroui/system';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system';
import { BreadcrumbItemVariantProps, SlotsToClasses, BreadcrumbItemSlots } from '@heroui/theme';
import { BreadcrumbItemProps } from '@react-types/breadcrumbs';
import { ReactRef } from '@heroui/react-utils';

interface Props extends Omit<HTMLHeroUIProps<"li">, keyof BreadcrumbItemProps>, BreadcrumbItemProps {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLLIElement | null>;
    /**
     * The item custom separator. It is a chevron by default.
     */
    separator?: ReactNode;
    /**
     * Whether the item is the last one.
     * @default false
     */
    isLast?: boolean;
    /**
     * Whether to hide the separator element.
     * @default false
     */
    hideSeparator?: boolean;
    /**
     * The start content of the item.
     */
    startContent?: ReactNode;
    /**
     * The end content of the item.
     */
    endContent?: ReactNode;
    /**
     * The breadcrumbs item classNames.
     */
    classNames?: SlotsToClasses<BreadcrumbItemSlots>;
}
type UseBreadcrumbItemProps = Props & BreadcrumbItemVariantProps;
declare function useBreadcrumbItem(originalProps: UseBreadcrumbItemProps): {
    Component: string;
    WrapperComponent: _heroui_system.As<any>;
    children: ReactNode;
    separator: ReactNode;
    startContent: ReactNode;
    endContent: ReactNode;
    isDisabled: boolean | undefined;
    isCurrent: boolean;
    isLast: boolean | undefined;
    hideSeparator: boolean;
    getBaseProps: () => {
        id?: string;
        'aria-label'?: string;
        'aria-labelledby'?: string;
        'aria-describedby'?: string;
        'aria-details'?: string;
        ref: react.RefObject<HTMLLIElement>;
        "data-slot": string;
        className: string;
    };
    getItemProps: PropGetter;
    getSeparatorProps: () => {
        "data-slot": string;
        "aria-hidden": boolean | "true" | "false";
        className: string;
    };
};
type UseBreadcrumbItemReturn = ReturnType<typeof useBreadcrumbItem>;

export { type UseBreadcrumbItemProps, type UseBreadcrumbItemReturn, useBreadcrumbItem };
