"use client";
import {
  virtualized_table_default
} from "./chunk-O5IH762T.mjs";
import {
  table_select_all_checkbox_default
} from "./chunk-PRBPVC6X.mjs";
import {
  useTable
} from "./chunk-6P56MRLR.mjs";
import {
  table_body_default
} from "./chunk-HDDKCVLI.mjs";
import {
  table_column_header_default
} from "./chunk-PZT4K2LB.mjs";
import {
  table_header_row_default
} from "./chunk-V2BF6S4T.mjs";
import {
  table_row_group_default
} from "./chunk-DVOW65RZ.mjs";

// src/table.tsx
import { useCallback } from "react";
import { Spacer } from "@heroui/spacer";
import { forwardRef } from "@heroui/system";
import { Fragment, jsx, jsxs } from "react/jsx-runtime";
var Table = forwardRef((props, ref) => {
  const {
    BaseComponent,
    Component,
    collection,
    values,
    topContent,
    topContentPlacement,
    bottomContentPlacement,
    bottomContent,
    removeWrapper,
    getBaseProps,
    getWrapperProps,
    getTableProps
  } = useTable({
    ...props,
    ref
  });
  const { isVirtualized, rowHeight = 40, maxTableHeight = 600 } = props;
  const shouldVirtualize = isVirtualized;
  const Wrapper = useCallback(
    ({ children }) => {
      if (removeWrapper) {
        return children;
      }
      return /* @__PURE__ */ jsx(BaseComponent, { ...getWrapperProps(), children });
    },
    [removeWrapper, getWrapperProps]
  );
  if (shouldVirtualize) {
    return /* @__PURE__ */ jsx(
      virtualized_table_default,
      {
        ...props,
        ref,
        maxTableHeight,
        rowHeight
      }
    );
  }
  return /* @__PURE__ */ jsxs("div", { ...getBaseProps(), children: [
    topContentPlacement === "outside" && topContent,
    /* @__PURE__ */ jsx(Wrapper, { children: /* @__PURE__ */ jsxs(Fragment, { children: [
      topContentPlacement === "inside" && topContent,
      /* @__PURE__ */ jsxs(Component, { ...getTableProps(), children: [
        /* @__PURE__ */ jsxs(table_row_group_default, { classNames: values.classNames, slots: values.slots, children: [
          collection.headerRows.map((headerRow) => /* @__PURE__ */ jsx(
            table_header_row_default,
            {
              classNames: values.classNames,
              node: headerRow,
              slots: values.slots,
              state: values.state,
              children: [...headerRow.childNodes].map(
                (column) => {
                  var _a;
                  return ((_a = column == null ? void 0 : column.props) == null ? void 0 : _a.isSelectionCell) ? /* @__PURE__ */ jsx(
                    table_select_all_checkbox_default,
                    {
                      checkboxesProps: values.checkboxesProps,
                      classNames: values.classNames,
                      color: values.color,
                      disableAnimation: values.disableAnimation,
                      node: column,
                      selectionMode: values.selectionMode,
                      slots: values.slots,
                      state: values.state
                    },
                    column == null ? void 0 : column.key
                  ) : /* @__PURE__ */ jsx(
                    table_column_header_default,
                    {
                      classNames: values.classNames,
                      node: column,
                      slots: values.slots,
                      state: values.state
                    },
                    column == null ? void 0 : column.key
                  );
                }
              )
            },
            headerRow == null ? void 0 : headerRow.key
          )),
          /* @__PURE__ */ jsx(Spacer, { as: "tr", tabIndex: -1, y: 1 })
        ] }),
        /* @__PURE__ */ jsx(
          table_body_default,
          {
            checkboxesProps: values.checkboxesProps,
            classNames: values.classNames,
            collection: values.collection,
            color: values.color,
            disableAnimation: values.disableAnimation,
            isSelectable: values.isSelectable,
            selectionMode: values.selectionMode,
            slots: values.slots,
            state: values.state
          }
        )
      ] }),
      bottomContentPlacement === "inside" && bottomContent
    ] }) }),
    bottomContentPlacement === "outside" && bottomContent
  ] });
});
Table.displayName = "HeroUI.Table";
var table_default = Table;

export {
  table_default
};
