const { SlashCommandBuilder, EmbedBuilder, PermissionFlagsBits } = require('discord.js');

module.exports = {
    data: new SlashCommandBuilder()
        .setName('mute')
        .setDescription('Empêche un utilisateur d\'envoyer des messages')
        .addUserOption(option =>
            option.setName('utilisateur')
                .setDescription('Utilisateur à mute')
                .setRequired(true)
        )
        .addStringOption(option =>
            option.setName('raison')
                .setDescription('Raison du mute')
                .setRequired(true)
        )
        .addIntegerOption(option =>
            option.setName('duree')
                .setDescription('Durée en minutes (max 28 jours = 40320 min)')
                .setMinValue(1)
                .setMaxValue(40320)
                .setRequired(false)
        ),
    
    async execute(interaction) {
        if (!interaction.member.permissions.has(PermissionFlagsBits.ModerateMembers)) {
            return interaction.reply({ 
                content: '❌ Tu n\'as pas la permission de timeout des utilisateurs!', 
                ephemeral: true 
            });
        }

        const targetUser = interaction.options.getUser('utilisateur');
        const reason = interaction.options.getString('raison');
        const duration = interaction.options.getInteger('duree') || 10;
        
        const targetMember = interaction.guild.members.cache.get(targetUser.id);

        if (!targetMember) {
            return interaction.reply({ 
                content: '❌ Utilisateur introuvable sur ce serveur!', 
                ephemeral: true 
            });
        }

        if (targetMember.permissions.has(PermissionFlagsBits.Administrator)) {
            return interaction.reply({ 
                content: '❌ Je ne peux pas mute un administrateur!', 
                ephemeral: true 
            });
        }

        if (targetMember.roles.highest.position >= interaction.member.roles.highest.position) {
            return interaction.reply({ 
                content: '❌ Tu ne peux pas mute quelqu\'un avec un rôle égal ou supérieur!', 
                ephemeral: true 
            });
        }

        try {
            const timeoutDuration = duration * 60 * 1000;
            const timeoutUntil = new Date(Date.now() + timeoutDuration);

            const dmEmbed = new EmbedBuilder()
                .setColor('#FFA500')
                .setTitle('🔇 Tu as été mute')
                .setDescription(`Tu as été mute sur le serveur **${interaction.guild.name}**`)
                .addFields(
                    { name: '📝 Raison', value: reason, inline: false },
                    { name: '⏰ Durée', value: `${duration} minute(s)`, inline: true },
                    { name: '👤 Modérateur', value: `${interaction.user}`, inline: true },
                    { name: '📅 Fin du mute', value: `<t:${Math.floor(timeoutUntil.getTime() / 1000)}:F>`, inline: false }
                )
                .setFooter({ text: 'Peerkinton • Modération' })
                .setTimestamp();

            try {
                await targetUser.send({ embeds: [dmEmbed] });
            } catch (error) {
                console.log('Impossible d\'envoyer le MP à l\'utilisateur mute');
            }

            await targetMember.timeout(timeoutDuration, `${reason} - Par ${interaction.user.tag}`);

            const successEmbed = new EmbedBuilder()
                .setColor('#00FF00')
                .setTitle('✅ Utilisateur mute')
                .setDescription(`**${targetUser.tag}** a été mute avec succès`)
                .addFields(
                    { name: '📝 Raison', value: reason, inline: false },
                    { name: '⏰ Durée', value: `${duration} minute(s)`, inline: true },
                    { name: '👤 Modérateur', value: `${interaction.user}`, inline: true },
                    { name: '📅 Fin du mute', value: `<t:${Math.floor(timeoutUntil.getTime() / 1000)}:F>`, inline: false }
                )
                .setFooter({ text: 'Peerkinton • Modération' })
                .setTimestamp();

            await interaction.reply({ embeds: [successEmbed] });

        } catch (error) {
            console.error(error);
            await interaction.reply({ 
                content: '❌ Erreur lors du mute. Vérifie mes permissions!', 
                ephemeral: true 
            });
        }
    }
};