const { REST, Routes } = require('discord.js');
const fs = require('fs');
const config = require('./config.json');

const commands = [];
const commandFiles = fs.readdirSync('./commands').filter(file => file.endsWith('.js'));

for (const file of commandFiles) {
    const command = require(`./commands/${file}`);
    if (command.data && command.data.toJSON) {
        commands.push(command.data.toJSON());
        console.log(`✅ Commande chargée: ${command.data.name}`);
    } else {
        console.log(`❌ Erreur avec la commande: ${file}`);
    }
}

const rest = new REST({ version: '10' }).setToken(config.token);

(async () => {
    try {
        console.log(`🚀 Début du déploiement de ${commands.length} commandes slash...`);

        const data = await rest.put(
            Routes.applicationCommands(config.clientId),
            { body: commands },
        );

        console.log(`✅ ${data.length} commandes slash déployées avec succès!`);
        console.log('Commandes disponibles:');
        data.forEach(cmd => {
            console.log(`  - /${cmd.name}: ${cmd.description}`);
        });
        
        console.log('\n🎉 Déploiement terminé! Tu peux maintenant lancer le bot avec: npm start');
        
    } catch (error) {
        console.error('❌ Erreur lors du déploiement:');
        
        if (error.code === 50001) {
            console.error('Erreur: Bot manque de permissions. Vérifie que ton bot a les bonnes permissions sur le serveur.');
        } else if (error.code === 401) {
            console.error('Erreur: Token invalide. Vérifie ton token dans config.json');
        } else if (error.status === 400) {
            console.error('Erreur: Client ID invalide ou problème avec les commandes');
        } else {
            console.error(error);
        }
        
        console.log('\n🔧 Vérifications:');
        console.log('1. Token bot correct dans config.json');
        console.log('2. Client ID correct dans config.json'); 
        console.log('3. Bot ajouté au serveur avec permissions applications.commands');
        process.exit(1);
    }
})();