const claudeHandler = require('../handlers/claudeHandler.js');

module.exports = {
    name: 'messageCreate',
    async execute(message) {
        if (message.author.bot) return;
        
        const guildConfig = global.guildConfigs.get(message.guild.id);
        if (!guildConfig) return;

        if (guildConfig.securityEnabled && 
            guildConfig.secureChannels && 
            guildConfig.secureChannels.includes(message.channel.id)) {
            
            const isSpamOrInsult = await claudeHandler.checkMessageSecurity(message.content);
            
            if (isSpamOrInsult) {
                try {
                    await message.delete();
                    await message.author.send(`⚠️ Ton message a été supprimé du serveur **${message.guild.name}** car il a été détecté comme spam ou contenu inapproprié.`);
                } catch (error) {
                    console.log('Impossible de supprimer le message ou d\'envoyer le MP');
                }
                return;
            }
        }

        if (guildConfig.conversationAnalysis && 
            guildConfig.analysisChannels && 
            guildConfig.analysisChannels.includes(message.channel.id)) {
            
            await claudeHandler.analyzeConversation(message);
        }
    },
};