<?php

require_once'header.php';

?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Pricing - OhMyPanel</title>
  <link rel="icon" type="image/png" href="/logo.png">
  <script src="https://cdn.tailwindcss.com"></script>
  <link href="https://fonts.googleapis.com/css2?family=Urbanist:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <style>
      body { font-family: 'Urbanist', sans-serif; }
      .pricing-card {
          transform: translateY(0);
          transition: transform 0.3s ease;
      }
      .pricing-card:hover {
          transform: translateY(-8px);
      }
      .popular-badge {
          position: absolute;
          top: -10px;
          left: 50%;
          transform: translateX(-50%);
          background: linear-gradient(45deg, #000, #333);
          color: white;
          padding: 6px 20px;
          border-radius: 20px;
          font-size: 12px;
          font-weight: 500;
          letter-spacing: 0.5px;
      }
      .billing-toggle {
          background: #f3f4f6;
          border-radius: 50px;
          padding: 4px;
          display: inline-flex;
          position: relative;
      }
      .billing-option {
          padding: 8px 16px;
          border-radius: 50px;
          cursor: pointer;
          transition: all 0.3s ease;
          font-weight: 300;
          font-size: 14px;
      }
      .billing-option.active {
          background: #000;
          color: #fff;
      }
      .price-display {
          transition: all 0.3s ease;
      }
      .store-calculator {
          background: linear-gradient(135deg, #f9fafb 0%, #f3f4f6 100%);
          border: 1px solid #e5e7eb;
          border-radius: 16px;
          padding: 32px;
      }
      .slider-container {
          margin: 20px 0;
      }
      .slider {
          width: 100%;
          height: 6px;
          border-radius: 5px;
          background: #d1d5db;
          outline: none;
          -webkit-appearance: none;
      }
      .slider::-webkit-slider-thumb {
          appearance: none;
          width: 20px;
          height: 20px;
          border-radius: 50%;
          background: #000;
          cursor: pointer;
      }
      .slider::-moz-range-thumb {
          width: 20px;
          height: 20px;
          border-radius: 50%;
          background: #000;
          cursor: pointer;
          border: none;
      }
      .feature-highlight {
          background: linear-gradient(135deg, #f9fafb 0%, #ffffff 100%);
          border-left: 4px solid #000;
      }
      .enterprise-card {
          background: linear-gradient(135deg, #000 0%, #1f1f1f 100%);
          color: white;
      }
  </style>
</head>
<body class="bg-white">

  <section class="pt-32 pb-12 px-6 md:px-12">
    <div class="max-w-4xl mx-auto text-center">
        <h1 class="text-5xl md:text-8xl font-light text-black tracking-tight mb-8">
            The <span class="font-bold">pricing</span> of a new way
        </h1>
        <p class="text-xl font-light text-gray-600 max-w-2xl mx-auto">
            Choose the solution that fits your business. Start with what you need, scale when you grow.
        </p>
    </div>
  </section>

  <section class="py-16 px-6 md:px-12">
    <div class="max-w-6xl mx-auto">
        <div class="text-center mb-12">
            <div class="billing-toggle mb-8">
                <div class="billing-option active" data-period="monthly">Monthly</div>
                <div class="billing-option" data-period="yearly">Yearly</div>
            </div>
            
            <div class="text-center">
                <span class="text-sm text-gray-500 font-light yearly-savings hidden">Save up to 15% with yearly commitment</span>
            </div>
        </div>
        
        <div class="grid lg:grid-cols-3 gap-8 mb-16">
            
            <div class="pricing-card relative bg-white border border-gray-200 p-8 rounded-2xl">
                <div class="text-center mb-8">
                    <h3 class="text-2xl font-light text-black mb-2">OMP Seatment</h3>
                    <p class="text-gray-500 font-light mb-6">Perfect for restaurants & cafés</p>
                    <div class="price-display">
                        <div class="text-5xl font-light text-black mb-2" data-monthly="89" data-yearly="920">€89</div>
                        <div class="text-gray-400 font-light billing-period">per month</div>
                    </div>
                </div>
                
                <div class="space-y-4 mb-8">
                    <div class="feature-highlight p-4 rounded-lg">
                        <div class="flex items-center">
                            <div class="w-2 h-2 bg-black rounded-full mr-3"></div>
                            <span class="text-gray-700 font-medium">Table ordering system</span>
                        </div>
                    </div>
                    <div class="flex items-center">
                        <div class="w-2 h-2 bg-black rounded-full mr-3"></div>
                        <span class="text-gray-700 font-light">Contactless payments</span>
                    </div>
                    <div class="flex items-center">
                        <div class="w-2 h-2 bg-black rounded-full mr-3"></div>
                        <span class="text-gray-700 font-light">Pre-ordering capabilities</span>
                    </div>
                    <div class="flex items-center">
                        <div class="w-2 h-2 bg-black rounded-full mr-3"></div>
                        <span class="text-gray-700 font-light">Real-time analytics</span>
                    </div>
                    <div class="flex items-center">
                        <div class="w-2 h-2 bg-black rounded-full mr-3"></div>
                        <span class="text-gray-700 font-light">Can algorithm integration</span>
                    </div>
                    <div class="flex items-center">
                        <div class="w-2 h-2 bg-black rounded-full mr-3"></div>
                        <span class="text-gray-700 font-light">Up to 50 tables</span>
                    </div>
                </div>
                
                <button class="w-full bg-black text-white py-4 font-light text-lg rounded-lg hover:bg-gray-900 transition-colors">
                    Pre-order now
                </button>
            </div>

            <div class="pricing-card relative bg-white border-2 border-black p-8 rounded-2xl shadow-lg">
                <div class="popular-badge">Most popular</div>
                <div class="text-center mb-8">
                    <h3 class="text-2xl font-light text-black mb-2">OMP Store</h3>
                    <p class="text-gray-500 font-light mb-6">Ideal for retail & e-commerce</p>
                    <div class="price-display">
                        <div class="text-5xl font-light text-black mb-2" data-monthly="149" data-yearly="1540">€149</div>
                        <div class="text-gray-400 font-light billing-period">per month</div>
                    </div>
                </div>
                
                <div class="space-y-4 mb-8">
                    <div class="feature-highlight p-4 rounded-lg">
                        <div class="flex items-center">
                            <div class="w-2 h-2 bg-black rounded-full mr-3"></div>
                            <span class="text-gray-700 font-medium">Advanced inventory management</span>
                        </div>
                    </div>
                    <div class="feature-highlight p-4 rounded-lg">
                        <div class="flex items-center">
                            <div class="w-2 h-2 bg-black rounded-full mr-3"></div>
                            <span class="text-gray-700 font-medium">Can predictive analytics</span>
                        </div>
                    </div>
                    <div class="flex items-center">
                        <div class="w-2 h-2 bg-black rounded-full mr-3"></div>
                        <span class="text-gray-700 font-light">Online ordering platform</span>
                    </div>
                    <div class="flex items-center">
                        <div class="w-2 h-2 bg-black rounded-full mr-3"></div>
                        <span class="text-gray-700 font-light">Click & Collect system</span>
                    </div>
                    <div class="flex items-center">
                        <div class="w-2 h-2 bg-black rounded-full mr-3"></div>
                        <span class="text-gray-700 font-light">Unlimited products</span>
                    </div>
                    <div class="flex items-center">
                        <div class="w-2 h-2 bg-black rounded-full mr-3"></div>
                        <span class="text-gray-700 font-light">Advanced integrations</span>
                    </div>
                </div>
                
                <button class="w-full bg-black text-white py-4 font-light text-lg rounded-lg hover:bg-gray-900 transition-colors">
                    Pre-order now
                </button>
            </div>

            <div class="pricing-card enterprise-card relative p-8 rounded-2xl">
                <div class="text-center mb-8">
                    <h3 class="text-2xl font-light text-white mb-2">Enterprise</h3>
                    <p class="text-gray-300 font-light mb-6">For multi-location businesses</p>
                    <div class="price-display">
                        <div class="text-4xl font-light text-white mb-2">Custom</div>
                        <div class="text-gray-400 font-light">pricing</div>
                    </div>
                </div>
                
                <div class="space-y-4 mb-8">
                    <div class="flex items-center">
                        <div class="w-2 h-2 bg-white rounded-full mr-3"></div>
                        <span class="text-gray-200 font-light">Everything in Store</span>
                    </div>
                    <div class="flex items-center">
                        <div class="w-2 h-2 bg-white rounded-full mr-3"></div>
                        <span class="text-gray-200 font-light">Multi-site management</span>
                    </div>
                    <div class="flex items-center">
                        <div class="w-2 h-2 bg-white rounded-full mr-3"></div>
                        <span class="text-gray-200 font-light">Volume discounts</span>
                    </div>
                    <div class="flex items-center">
                        <div class="w-2 h-2 bg-white rounded-full mr-3"></div>
                        <span class="text-gray-200 font-light">Priority 24/7 support</span>
                    </div>
                    <div class="flex items-center">
                        <div class="w-2 h-2 bg-white rounded-full mr-3"></div>
                        <span class="text-gray-200 font-light">Custom integrations</span>
                    </div>
                    <div class="flex items-center">
                        <div class="w-2 h-2 bg-white rounded-full mr-3"></div>
                        <span class="text-gray-200 font-light">Dedicated account manager</span>
                    </div>
                </div>
                
                <button class="w-full bg-white text-black py-4 font-light text-lg rounded-lg hover:bg-gray-100 transition-colors">
                    Contact sales
                </button>
            </div>
        </div>

        <div class="text-center">
            <p class="text-gray-500 font-light mb-4">All plans include Can algorithm integration and come with a 30-day money-back guarantee</p>
            <p class="text-sm text-gray-400 font-light">Expected delivery: January 2026</p>
        </div>
    </div>
  </section>

  <section class="py-20 px-6 md:px-12 bg-gray-50">
    <div class="max-w-5xl mx-auto">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-6xl font-light text-black tracking-tight mb-4">
                Need something <span class="font-bold">different</span>?
            </h2>
            <p class="text-lg font-light text-gray-600">Explore our specialised solutions</p>
        </div>
        
        <div class="grid md:grid-cols-2 gap-8 mb-16">
            <div class="bg-white p-8 rounded-2xl border border-gray-200">
                <div class="flex items-center justify-between mb-6">
                    <div>
                        <h3 class="text-2xl font-light text-black mb-2">OMP Oneday</h3>
                        <p class="text-gray-500 font-light">Single-event licence</p>
                    </div>
                    <div class="text-right">
                        <div class="text-3xl font-light text-black">€49</div>
                        <div class="text-gray-400 font-light text-sm">per event</div>
                    </div>
                </div>
                
                <div class="space-y-3 mb-6">
                    <div class="flex items-center">
                        <div class="w-2 h-2 bg-black rounded-full mr-3"></div>
                        <span class="text-gray-700 font-light">Perfect for pop-ups & markets</span>
                    </div>
                    <div class="flex items-center">
                        <div class="w-2 h-2 bg-black rounded-full mr-3"></div>
                        <span class="text-gray-700 font-light">Tap to Pay iPhone support</span>
                    </div>
                    <div class="flex items-center">
                        <div class="w-2 h-2 bg-black rounded-full mr-3"></div>
                        <span class="text-gray-700 font-light">Instant activation</span>
                    </div>
                </div>
                
                <button class="w-full bg-gray-900 text-white py-3 font-light rounded-lg hover:bg-black transition-colors">
                    Buy for next event
                </button>
            </div>

            <div class="store-calculator">
                <h3 class="text-2xl font-light text-black mb-4">Volume Pricing Calculator</h3>
                <p class="text-gray-600 font-light mb-6">See how much you can save with multiple locations</p>
                
                <div class="mb-4">
                    <label class="block text-sm font-light text-gray-600 mb-2">Number of locations</label>
                    <div class="slider-container">
                        <input type="range" min="1" max="100" value="1" class="slider" id="volume-slider">
                        <div class="flex justify-between text-sm text-gray-500 mt-2">
                            <span>1</span>
                            <span>50</span>
                            <span>100+</span>
                        </div>
                    </div>
                    <div class="text-center mt-4">
                        <span class="text-lg font-light">Locations: </span>
                        <span class="text-xl font-medium" id="volume-count">1</span>
                    </div>
                </div>
                
                <div class="bg-white p-6 rounded-lg border">
                    <div class="text-center">
                        <div class="text-2xl font-light text-black mb-1" id="volume-total">€149</div>
                        <div class="text-gray-500 font-light text-sm">per month total</div>
                        <div class="text-sm text-green-600 font-light mt-2" id="volume-discount">No discount</div>
                    </div>
                </div>
                
                <button class="w-full bg-black text-white py-3 font-light rounded-lg hover:bg-gray-900 transition-colors mt-4">
                    Get enterprise quote
                </button>
            </div>
        </div>
    </div>
  </section>

  <section class="py-20 px-6 md:px-12">
    <div class="max-w-4xl mx-auto">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-6xl font-light text-black tracking-tight mb-8">
                Questions & <span class="font-bold">answers</span>
            </h2>
        </div>
        
        <div class="space-y-1">
            <div class="border-b border-gray-200 py-8">
                <h3 class="text-xl font-light text-black mb-4">What's included in all plans?</h3>
                <p class="text-gray-600 font-light">All plans include the Can algorithm, real-time analytics, cloud hosting, and basic support. No setup fees or hidden costs.</p>
            </div>
            
            <div class="border-b border-gray-200 py-8">
                <h3 class="text-xl font-light text-black mb-4">Can I switch plans anytime?</h3>
                <p class="text-gray-600 font-light">Yes, you can upgrade or downgrade at any time. Changes take effect at your next billing cycle.</p>
            </div>
            
            <div class="border-b border-gray-200 py-8">
                <h3 class="text-xl font-light text-black mb-4">When will OMP be available?</h3>
                <p class="text-gray-600 font-light">Pre-orders open December 7th, 2025. Full launch and delivery scheduled for January 2026.</p>
            </div>
            
            <div class="border-b border-gray-200 py-8">
                <h3 class="text-xl font-light text-black mb-4">Do you offer volume discounts?</h3>
                <p class="text-gray-600 font-light">Yes, progressive discounts start at 5+ locations. Enterprise pricing available for 25+ locations with additional benefits.</p>
            </div>
            
            <div class="py-8">
                <h3 class="text-xl font-light text-black mb-4">What hardware do I need?</h3>
                <p class="text-gray-600 font-light">OMP works with your existing devices. No additional hardware required - just your current tablets, phones, or computers.</p>
            </div>
        </div>
    </div>
  </section>

  <section class="py-32 px-6 md:px-12 bg-black text-white">
    <div class="max-w-4xl mx-auto text-center">
        <h2 class="text-4xl md:text-7xl font-light tracking-tight mb-8">
            Ready to <span class="font-bold">modernise</span>?
        </h2>
        <p class="text-xl font-light text-gray-300 mb-12">
            Join thousands of businesses transforming their operations with OhMyPanel.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <button class="bg-white text-black px-8 py-4 font-light text-lg rounded-lg hover:bg-gray-100 transition-colors">
                Join waitlist
            </button>
            <button class="border border-white text-white px-8 py-4 font-light text-lg rounded-lg hover:bg-white hover:text-black transition-colors">
                Schedule demo
            </button>
        </div>
    </div>
  </section>

  <footer class="bg-white text-black py-16 px-6 md:px-12 border-t border-gray-200">
    <div class="max-w-7xl mx-auto">
        <div class="grid md:grid-cols-4 gap-12 mb-16">
            <div class="md:col-span-2">
                <h3 class="text-3xl md:text-5xl font-light tracking-tight mb-6">OhMyPanel</h3>
                <p class="text-gray-600 font-light text-lg max-w-md mb-8">
                    Software suite designed for business improvement and change forever.
                </p>
            </div>
            
            <div>
                <h4 class="text-lg font-light mb-6">Products</h4>
                <div class="space-y-3">
                    <a href="#" class="block text-gray-500 font-light hover:text-black transition-colors">OMP Seatment</a>
                    <a href="#" class="block text-gray-500 font-light hover:text-black transition-colors">OMP Store</a>
                    <a href="#" class="block text-gray-500 font-light hover:text-black transition-colors">OMP Oneday</a>
                    <a href="#" class="block text-gray-500 font-light hover:text-black transition-colors">Enterprise</a>
                </div>
            </div>
            
            <div>
                <h4 class="text-lg font-light mb-6">Company</h4>
                <div class="space-y-3">
                    <a href="#" class="block text-gray-500 font-light hover:text-black transition-colors">About</a>
                    <a href="#" class="block text-gray-500 font-light hover:text-black transition-colors">Careers</a>
                    <a href="#" class="block text-gray-500 font-light hover:text-black transition-colors">Press</a>
                    <a href="https://imators.com/support" class="block text-gray-500 font-light hover:text-black transition-colors">Contact</a>
                </div>
            </div>
        </div>
        
        <div class="border-t border-gray-200 pt-8">
            <div class="flex flex-col md:flex-row justify-between items-start md:items-center space-y-4 md:space-y-0">
                <div class="flex flex-col md:flex-row space-y-2 md:space-y-0 md:space-x-8">
                    <span class="text-gray-500 font-light">© 2025 Imators LLC. All rights reserved.</span>
                    <span class="text-gray-500 font-light">Launch: January 2026</span>
                </div>
                <div class="flex space-x-8">
                    <a href="https://imators.com/privacy" class="text-gray-500 font-light hover:text-black transition-colors">Privacy</a>
                    <a href="https://imators.com/terms-of-use" class="text-gray-500 font-light hover:text-black transition-colors">Terms</a>
                    <a href="https://imators.com/legal-notice" class="text-gray-500 font-light hover:text-black transition-colors">Legal</a>
                </div>
            </div>
        </div>
    </div>
  </footer>

  <script>
      const billingOptions = document.querySelectorAll('.billing-option');
      const priceElements = document.querySelectorAll('[data-monthly]');
      const billingPeriods = document.querySelectorAll('.billing-period');
      const yearlySavings = document.querySelector('.yearly-savings');

      function calculateVolumePrice(count) {
          let basePrice = 149;
          let total = count * basePrice;
          let discount = "No discount";
          
          if (count >= 50) {
              total = count * (basePrice * 0.65);
              discount = "35% enterprise discount";
          } else if (count >= 25) {
              total = count * (basePrice * 0.75);
              discount = "25% volume discount";
          } else if (count >= 15) {
              total = count * (basePrice * 0.80);
              discount = "20% volume discount";
          } else if (count >= 10) {
              total = count * (basePrice * 0.85);
              discount = "15% volume discount";
          } else if (count >= 5) {
              total = count * (basePrice * 0.90);
              discount = "10% volume discount";
          }
          
          return { total: Math.round(total), discount };
      }

      const volumeSlider = document.getElementById('volume-slider');
      const volumeCount = document.getElementById('volume-count');
      const volumeTotal = document.getElementById('volume-total');
      const volumeDiscount = document.getElementById('volume-discount');

      volumeSlider.addEventListener('input', function() {
          const count = parseInt(this.value);
          const result = calculateVolumePrice(count);
          
          volumeCount.textContent = count;
          volumeTotal.textContent = `€${result.total.toLocaleString()}`;
          volumeDiscount.textContent = result.discount;
      });

      billingOptions.forEach(option => {
          option.addEventListener('click', () => {
              billingOptions.forEach(opt => opt.classList.remove('active'));
              option.classList.add('active');
              
              const period = option.dataset.period;
              
              priceElements.forEach(element => {
                  const monthlyPrice = element.dataset.monthly;
                  const yearlyPrice = element.dataset.yearly;
                  
                  if (period === 'monthly') {
                      element.textContent = `€${monthlyPrice}`;
                  } else if (period === 'yearly') {
                      element.textContent = `€${yearlyPrice}`;
                  }
              });
              
              billingPeriods.forEach(period_element => {
                  if (period === 'monthly') {
                      period_element.textContent = 'per month';
                  } else if (period === 'yearly') {
                      period_element.textContent = 'per year';
                  }
              });
              
              yearlySavings.classList.add('hidden');
              
              if (period === 'yearly') {
                  yearlySavings.classList.remove('hidden');
              }
          });
      });
  </script>

</body>
</html>