<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $firstName = htmlspecialchars($_POST['first_name']);
    $lastName = htmlspecialchars($_POST['last_name']);
    $email = htmlspecialchars($_POST['email']);
    $birthDate = htmlspecialchars($_POST['birth_date']);
    $country = htmlspecialchars($_POST['country']);
    $countryCode = htmlspecialchars($_POST['country_code']);
    $phone = htmlspecialchars($_POST['phone']);
    
    $birthDateObj = new DateTime($birthDate);
    $today = new DateTime();
    $age = $today->diff($birthDateObj)->y;
    
    if ($age < 13) {
        header('Location: cantesso.php?error=age');
        exit();
    }
    
    $adminEmail = 'izhakaktas@gmail.com';
    
    $applicantSubject = 'Cantesso Academy - Application Received';
    $adminSubject = 'New Cantesso Academy Application';
    
    $applicantMessage = "
    <!DOCTYPE html>
    <html lang='en-GB'>
    <head>
        <meta charset='UTF-8'>
        <style>
            body {
                font-family: 'Arial', sans-serif;
                background-color: #f9f0e6;
                margin: 0;
                padding: 20px;
            }
            .container {
                max-width: 600px;
                margin: 0 auto;
                background-color: white;
                border-radius: 8px;
                overflow: hidden;
                box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            }
            .header {
                background-color: #374151;
                color: white;
                padding: 30px;
                text-align: center;
            }
            .content {
                padding: 30px;
                color: #374151;
            }
            .footer {
                background-color: #f3f4f6;
                padding: 20px;
                text-align: center;
                font-size: 12px;
                color: #6b7280;
            }
            h1 {
                margin: 0;
                font-size: 24px;
                font-weight: 300;
                letter-spacing: 1px;
            }
            h2 {
                color: #374151;
                font-size: 18px;
                margin-bottom: 15px;
            }
            p {
                line-height: 1.6;
                margin-bottom: 15px;
            }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h1>Cantesso Academy</h1>
                <p>Young Developers Programme</p>
            </div>
            <div class='content'>
                <h2>Dear $firstName $lastName,</h2>
                <p>Thank you for your application to Cantesso Academy. We have received your application and our team will carefully review it.</p>
                <p>We will examine your application and get back to you within the next few days with our decision.</p>
                <p>Should you have any questions in the meantime, please do not hesitate to contact us.</p>
                <p>Best regards,<br>
                The Cantesso Academy Team<br>
                aktascorp</p>
            </div>
            <div class='footer'>
                <p>&copy; 2025 AktasCorporation. All rights reserved.<br>
                For any enquiries, contact us at msg@aktascorp.com</p>
            </div>
        </div>
    </body>
    </html>
    ";
    
    $adminMessage = "
    <!DOCTYPE html>
    <html lang='en-GB'>
    <head>
        <meta charset='UTF-8'>
        <style>
            body {
                font-family: 'Arial', sans-serif;
                background-color: #f9f0e6;
                margin: 0;
                padding: 20px;
            }
            .container {
                max-width: 600px;
                margin: 0 auto;
                background-color: white;
                border-radius: 8px;
                overflow: hidden;
                box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            }
            .header {
                background-color: #374151;
                color: white;
                padding: 30px;
                text-align: center;
            }
            .content {
                padding: 30px;
                color: #374151;
            }
            .info-box {
                background-color: #f3f4f6;
                padding: 20px;
                border-radius: 8px;
                margin: 20px 0;
            }
            .info-row {
                margin: 10px 0;
                display: flex;
            }
            .info-label {
                font-weight: bold;
                width: 150px;
                display: inline-block;
            }
            .info-value {
                flex: 1;
            }
            h1 {
                margin: 0;
                font-size: 24px;
                font-weight: 300;
                letter-spacing: 1px;
            }
            h2 {
                color: #374151;
                font-size: 18px;
                margin-bottom: 15px;
            }
            p {
                line-height: 1.6;
                margin-bottom: 15px;
            }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h1>New Application</h1>
                <p>Cantesso Academy</p>
            </div>
            <div class='content'>
                <h2>New Application Received</h2>
                <p>A new application has been submitted to Cantesso Academy. Please find the applicant details below:</p>
                
                <div class='info-box'>
                    <div class='info-row'>
                        <span class='info-label'>First Name:</span>
                        <span class='info-value'>$firstName</span>
                    </div>
                    <div class='info-row'>
                        <span class='info-label'>Last Name:</span>
                        <span class='info-value'>$lastName</span>
                    </div>
                    <div class='info-row'>
                        <span class='info-label'>Email:</span>
                        <span class='info-value'>$email</span>
                    </div>
                    <div class='info-row'>
                        <span class='info-label'>Date of Birth:</span>
                        <span class='info-value'>$birthDate (Age: $age)</span>
                    </div>
                    <div class='info-row'>
                        <span class='info-label'>Country:</span>
                        <span class='info-value'>$country</span>
                    </div>
                    <div class='info-row'>
                        <span class='info-label'>Phone Number:</span>
                        <span class='info-value'>$countryCode $phone</span>
                    </div>
                </div>
                
                <p>Please review this application and respond to the applicant accordingly.</p>
                
                <p>Best regards,<br>
                Cantesso Academy System</p>
            </div>
        </div>
    </body>
    </html>
    ";
    
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= 'From: noreply@aktascorp.com' . "\r\n";
    
    $applicantSent = mail($email, $applicantSubject, $applicantMessage, $headers);
    $adminSent = mail($adminEmail, $adminSubject, $adminMessage, $headers);
    
    if ($applicantSent && $adminSent) {
        header('Location: cantesso.php?success=1');
    } else {
        header('Location: cantesso.php?error=email');
    }
    exit();
} else {
    header('Location: cantesso.php');
    exit();
}
?>