<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="logo_new.png">
    <title>Projets & Idées - Vert Chasseur</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Abril+Fatface&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            background-color: #ffffff;
        }
        .dark body {
            background-color: #000000;
        }
        .card-hover {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .card-hover:hover {
            transform: translateY(-6px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.08);
        }
        .dark .card-hover:hover {
            box-shadow: 0 20px 40px rgba(0,0,0,0.3);
        }
        .txt-chasseur {
            font-family: "Princess Sofia", serif;
            font-weight: 400;
        }
        .badge-pending {
            @apply bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-200;
        }
        .badge-approved {
            @apply bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200;
        }
        .badge-rejected {
            @apply bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200;
        }
        .badge-in_progress {
            @apply bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200;
        }
        .badge-completed {
            @apply bg-purple-100 text-purple-800 dark:bg-purple-900 dark:text-purple-200;
        }
        .approval-bar {
            @apply h-2 bg-gray-200 dark:bg-gray-700 rounded-full overflow-hidden;
        }
        .approval-fill {
            @apply h-full bg-green-500 transition-all duration-300;
        }
        .comment-item {
            @apply bg-stone-50 dark:bg-stone-800 p-4 rounded-lg border border-stone-200 dark:border-stone-700;
        }
    </style>
</head>
<body class="transition-colors duration-300">
<?php 
include 'header.php';
include 'db.php';

$filter_category = isset($_GET['category']) ? $_GET['category'] : 'all';
$filter_status = isset($_GET['status']) ? $_GET['status'] : 'all';

$query = "SELECT * FROM projects WHERE 1=1";
if ($filter_category !== 'all') {
    $query .= " AND category = '" . $conn->real_escape_string($filter_category) . "'";
}
if ($filter_status !== 'all') {
    $query .= " AND status = '" . $conn->real_escape_string($filter_status) . "'";
}
$query .= " ORDER BY status = 'pending' DESC, approval_count DESC";

$result = $conn->query($query);
$projects = $result->fetch_all(MYSQLI_ASSOC);

$categories_result = $conn->query("SELECT DISTINCT category FROM projects ORDER BY category");
$categories = $categories_result->fetch_all(MYSQLI_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['project_id'], $_POST['vote_type'])) {
    $project_id = intval($_POST['project_id']);
    $vote_type = $_POST['vote_type'];
    
    if ($vote_type === 'approve') {
        $conn->query("UPDATE projects SET approval_count = approval_count + 1 WHERE id = $project_id");
    } elseif ($vote_type === 'reject') {
        $conn->query("UPDATE projects SET rejection_count = rejection_count + 1 WHERE id = $project_id");
    }
    
    header('Location: ' . $_SERVER['REQUEST_URI']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add_comment') {
    $project_id = intval($_POST['project_id']);
    $comment_author = $conn->real_escape_string($_POST['comment_author']);
    $comment_text = $conn->real_escape_string($_POST['comment_text']);
    
    $get_comments = $conn->query("SELECT comments FROM projects WHERE id = $project_id");
    $row = $get_comments->fetch_assoc();
    $existing_comments = $row['comments'] ? $row['comments'] : '';
    
    $new_comment = date('Y-m-d H:i:s') . ' | ' . $comment_author . ' : ' . $comment_text . "\n";
    $all_comments = $existing_comments . $new_comment;
    
    $all_comments = $conn->real_escape_string($all_comments);
    $conn->query("UPDATE projects SET comments = '$all_comments' WHERE id = $project_id");
    
    header('Location: ' . $_SERVER['REQUEST_URI']);
    exit;
}

$conn->close();
?>

<script>
    if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
        document.documentElement.classList.add('dark');
    }
    window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
        if (e.matches) {
            document.documentElement.classList.add('dark');
        } else {
            document.documentElement.classList.remove('dark');
        }
    });

    function toggleComments(id) {
        const section = document.getElementById('comments-' + id);
        section.classList.toggle('hidden');
    }
</script>

<main class="min-h-screen px-8 md:px-16 py-32 max-w-7xl mx-auto">
    <div class="mb-24">
        <p class="text-stone-500 dark:text-stone-400 text-xs tracking-widest uppercase mb-4 font-light">Uccle · Bruxelles</p>
        <h1 class="text-4xl md:text-6xl font-light mb-6 text-stone-800 dark:text-white tracking-tight leading-tight">Projets & Idées <span class="txt-chasseur font-normal">Vert Chasseur</span></h1>
        <p class="text-lg text-stone-600 dark:text-stone-400 leading-relaxed max-w-2xl font-light">
            Découvrez les initiatives et projets en cours pour améliorer notre quartier. Votez pour soutenir les idées que vous appréciez et aidez la commune à faire les meilleurs choix pour Vert Chasseur.
        </p>
    </div>

    <div class="mb-12 flex flex-col md:flex-row gap-4 items-start md:items-center">
        <div class="flex-1 flex flex-col md:flex-row gap-4">
            <form method="GET" class="flex flex-col md:flex-row gap-4 w-full">
                <div>
                    <label class="block text-xs text-stone-600 dark:text-stone-400 uppercase tracking-widest mb-2">Catégorie</label>
                    <select name="category" onchange="this.closest('form').submit()" class="px-4 py-2 border border-stone-200 dark:border-stone-800 rounded-lg bg-white dark:bg-stone-900 text-stone-900 dark:text-white text-sm">
                        <option value="all" <?php echo $filter_category === 'all' ? 'selected' : ''; ?>>Toutes les catégories</option>
                        <?php foreach ($categories as $cat): ?>
                        <option value="<?php echo htmlspecialchars($cat['category']); ?>" <?php echo $filter_category === $cat['category'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($cat['category']); ?>
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div>
                    <label class="block text-xs text-stone-600 dark:text-stone-400 uppercase tracking-widest mb-2">Statut</label>
                    <select name="status" onchange="this.closest('form').submit()" class="px-4 py-2 border border-stone-200 dark:border-stone-800 rounded-lg bg-white dark:bg-stone-900 text-stone-900 dark:text-white text-sm">
                        <option value="all" <?php echo $filter_status === 'all' ? 'selected' : ''; ?>>Tous les statuts</option>
                        <option value="pending" <?php echo $filter_status === 'pending' ? 'selected' : ''; ?>>En attente</option>
                        <option value="approved" <?php echo $filter_status === 'approved' ? 'selected' : ''; ?>>Approuvé</option>
                        <option value="in_progress" <?php echo $filter_status === 'in_progress' ? 'selected' : ''; ?>>En cours</option>
                        <option value="rejected" <?php echo $filter_status === 'rejected' ? 'selected' : ''; ?>>Rejeté</option>
                        <option value="completed" <?php echo $filter_status === 'completed' ? 'selected' : ''; ?>>Complété</option>
                    </select>
                </div>
            </form>
        </div>
    </div>

    <div class="space-y-6">
        <?php foreach ($projects as $project): 
            $total_votes = $project['approval_count'] + $project['rejection_count'];
            $approval_percentage = $total_votes > 0 ? ($project['approval_count'] / $total_votes) * 100 : 0;
            $status_badge = 'badge-' . $project['status'];
            $comments_array = $project['comments'] ? array_filter(explode("\n", trim($project['comments']))) : [];
        ?>
        <div class="card-hover bg-white dark:bg-stone-900 border border-stone-200 dark:border-stone-800 rounded-xl p-8 transition-all">
            <div class="flex flex-col md:flex-row md:items-start md:justify-between mb-6 gap-4">
                <div class="flex-1">
                    <div class="flex flex-wrap gap-2 mb-3">
                        <span class="px-3 py-1 rounded-full text-xs font-medium text-stone-700 dark:text-stone-300 bg-stone-100 dark:bg-stone-800">
                            <?php echo htmlspecialchars($project['category']); ?>
                        </span>
                        <span class="<?php echo $status_badge; ?> px-3 py-1 rounded-full text-xs font-medium">
                            <?php 
                                $status_labels = [
                                    'pending' => 'En attente',
                                    'approved' => 'Approuvé',
                                    'rejected' => 'Rejeté',
                                    'in_progress' => 'En cours',
                                    'completed' => 'Complété'
                                ];
                                echo $status_labels[$project['status']];
                            ?>
                        </span>
                    </div>
                    <h3 class="text-2xl font-medium mb-2 text-stone-900 dark:text-white">
                        <?php echo htmlspecialchars($project['title']); ?>
                    </h3>
                    <p class="text-stone-600 dark:text-stone-400 leading-relaxed mb-4">
                        <?php echo htmlspecialchars($project['description']); ?>
                    </p>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6 pb-6 border-b border-stone-200 dark:border-stone-800">
                <div>
                    <p class="text-xs text-stone-500 dark:text-stone-500 uppercase tracking-widest mb-2">Date prévue</p>
                    <p class="text-lg font-medium text-stone-900 dark:text-white">
                        <?php echo date('d M Y', strtotime($project['date_planned'])); ?>
                    </p>
                </div>
                <div>
                    <p class="text-xs text-stone-500 dark:text-stone-500 uppercase tracking-widest mb-2">Votes totaux</p>
                    <p class="text-lg font-medium text-stone-900 dark:text-white">
                        <?php echo $total_votes; ?> votes
                    </p>
                </div>
            </div>

            <div class="mb-6">
                <div class="flex justify-between items-center mb-2">
                    <p class="text-xs text-stone-600 dark:text-stone-400 uppercase tracking-widest">Approbations</p>
                    <p class="text-sm font-medium text-stone-900 dark:text-white">
                        <?php echo $project['approval_count']; ?> pour / <?php echo $project['rejection_count']; ?> contre
                    </p>
                </div>
                <div class="approval-bar">
                    <div class="approval-fill" style="width: <?php echo $approval_percentage; ?>%"></div>
                </div>
            </div>

            <div class="flex gap-3 mb-6">
                <form method="POST" class="flex-1">
                    <input type="hidden" name="project_id" value="<?php echo $project['id']; ?>">
                    <input type="hidden" name="vote_type" value="approve">
                    <button type="submit" class="w-full px-4 py-3 bg-green-500 hover:bg-green-600 text-white rounded-lg font-medium text-sm transition-colors">
                        <i class="fas fa-thumbs-up mr-2"></i>Approuver
                    </button>
                </form>
                <form method="POST" class="flex-1">
                    <input type="hidden" name="project_id" value="<?php echo $project['id']; ?>">
                    <input type="hidden" name="vote_type" value="reject">
                    <button type="submit" class="w-full px-4 py-3 bg-red-500 hover:bg-red-600 text-white rounded-lg font-medium text-sm transition-colors">
                        <i class="fas fa-thumbs-down mr-2"></i>Rejeter
                    </button>
                </form>
            </div>

            <button onclick="toggleComments(<?php echo $project['id']; ?>)" class="w-full px-4 py-2 bg-stone-100 dark:bg-stone-800 text-stone-900 dark:text-white rounded-lg font-medium text-sm mb-4 hover:bg-stone-200 dark:hover:bg-stone-700 transition-colors">
                <i class="fas fa-comments mr-2"></i>Commentaires (<?php echo count($comments_array); ?>)
            </button>

            <div id="comments-<?php echo $project['id']; ?>" class="hidden">
                <div class="space-y-3 mb-4 max-h-64 overflow-y-auto">
                    <?php if (!empty($comments_array)): ?>
                        <?php foreach ($comments_array as $comment): ?>
                        <div class="comment-item">
                            <p class="text-stone-700 dark:text-stone-300 text-sm whitespace-pre-wrap"><?php echo htmlspecialchars($comment); ?></p>
                        </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <p class="text-stone-500 dark:text-stone-400 text-sm italic">Aucun commentaire pour le moment.</p>
                    <?php endif; ?>
                </div>

                <form method="POST" class="space-y-3">
                    <input type="hidden" name="action" value="add_comment">
                    <input type="hidden" name="project_id" value="<?php echo $project['id']; ?>">
                    
                    <input type="text" name="comment_author" placeholder="Ton nom" required class="w-full px-4 py-2 border border-stone-200 dark:border-stone-800 rounded-lg bg-white dark:bg-stone-800 text-stone-900 dark:text-white text-sm" maxlength="100">
                    
                    <textarea name="comment_text" placeholder="Ton commentaire..." required rows="3" class="w-full px-4 py-2 border border-stone-200 dark:border-stone-800 rounded-lg bg-white dark:bg-stone-800 text-stone-900 dark:text-white text-sm" maxlength="500"></textarea>
                    
                    <button type="submit" class="w-full px-4 py-2 bg-stone-900 dark:bg-white text-white dark:text-stone-900 rounded-lg font-medium text-sm hover:bg-stone-800 dark:hover:bg-stone-100 transition-colors">
                        Ajouter un commentaire
                    </button>
                </form>
            </div>
        </div>
        <?php endforeach; ?>
    </div>

    <?php if (empty($projects)): ?>
    <div class="text-center py-16">
        <p class="text-stone-600 dark:text-stone-400 text-lg">Aucun projet ne correspond à vos critères de filtrage.</p>
    </div>
    <?php endif; ?>

</main>

<footer class="w-full py-6 px-8 md:px-16 border-t border-stone-200 dark:border-stone-800">
    <p class="text-xs text-stone-500 dark:text-stone-400">© 2025 Vert Chasseur · A <a href="https://aktascorp.com" class="underline hover:text-stone-700 dark:hover:text-stone-300">aktascorp</a> member</p>
</footer>

</body>
</html>