const noble = require('@abandonware/noble');  // Bluetooth
const axios = require('axios');  // Pour scanner les caméras RTSP
const readline = require('readline-sync');  // Interface en ligne de commande

// Fonction pour scanner les appareils Bluetooth
function scanBluetooth() {
    console.log("[*] Scan Bluetooth en cours...");
    
    noble.startScanning([], true);  // Démarre le scan Bluetooth
    noble.on('discover', (device) => {
        console.log(`📡 Appareil Bluetooth trouvé : ${device.advertisement.localName || 'Inconnu'} - ${device.address}`);
    });

    // Arrêter le scan après 5 secondes
    setTimeout(() => {
        noble.stopScanning();
        console.log("[*] Scan terminé.");
    }, 5000);
}

// Fonction pour scanner les caméras RTSP
async function scanRTSP(ipRange) {
    console.log("[*] Scan des caméras IP en cours...");
    for (let i = 1; i <= 254; i++) {
        let ip = `${ipRange}.${i}`;
        try {
            // Tester si la caméra est disponible sur le port 554 (RTSP)
            await axios.get(`http://${ip}:554`, { timeout: 500 });
            console.log(`📷 Caméra trouvée à ${ip}`);
        } catch (error) {
            // Si la connexion échoue, passer à l'adresse suivante
        }
    }
}

// Interface utilisateur
while (true) {
    console.log("\n=== Détection des appareils ===");
    console.log("1️⃣ Scanner Bluetooth");
    console.log("2️⃣ Scanner les caméras RTSP");
    console.log("3️⃣ Quitter");
    
    let choix = readline.question("Sélectionne une option : ");
    
    if (choix === "1") {
        scanBluetooth();
    } else if (choix === "2") {
        let ipBase = readline.question("Entrer la base de l'IP (ex: 192.168.1) : ");
        scanRTSP(ipBase);
    } else if (choix === "3") {
        console.log("👋 Bye !");
        process.exit();  // Quitte le programme
    } else {
        console.log("❌ Option invalide, réessaye !");
    }
}