<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Out - Food Ordering</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300&display=swap" rel="stylesheet">
    <script src="https://js.stripe.com/v3/"></script>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
    </style>
</head>
<body class="bg-white text-black">
    <div class="banner w-full h-96 bg-fixed bg-cover bg-center" style="background-image: url('banner.jpg')"></div>
    
    <div class="container mx-auto px-4 py-8 max-w-4xl">
        <div class="grid md:grid-cols-2 gap-6" id="products">
            <?php
            require_once 'db.php';
            $stmt = $db->query("SELECT * FROM products");
            while($product = $stmt->fetch()) {
                echo '
                <div class="flex flex-col md:flex-row gap-4 bg-white p-4 rounded-lg shadow">
                    <div class="w-full md:w-48 h-48 bg-gray-100 rounded-lg">
                        <img src="'.$product['image_url'].'" class="w-full h-full object-cover rounded-lg">
                    </div>
                    <div class="flex-1">
                        <h2 class="text-xl font-semibold">'.$product['title'].'</h2>
                        <p class="mt-2 text-gray-600">'.$product['description'].'</p>
                        <div class="mt-4 flex items-center gap-4">
                            <input type="number" min="1" value="1" class="quantity-input w-20 p-2 border rounded" data-id="'.$product['id'].'">
                            <button onclick="addToCart('.$product['id'].')" class="px-4 py-2 bg-black text-white rounded hover:bg-gray-800">Add</button>
                        </div>
                    </div>
                </div>';
            }
            ?>
        </div>
    </div>

    <button id="cartButton" class="fixed bottom-8 left-1/2 transform -translate-x-1/2 bg-black text-white px-6 py-3 rounded-full hover:bg-gray-800 transition-all duration-300">
        Cart (0)
    </button>

    <div id="successNotification" class="fixed bottom-8 left-1/2 transform -translate-x-1/2 bg-green-500 text-white px-6 py-3 rounded-lg opacity-0 transition-all duration-300">
        Added successfully
    </div>

    <div id="cartModal" class="fixed inset-0 bg-black bg-opacity-50 hidden">
        <div class="fixed top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 bg-white p-6 rounded-lg w-11/12 max-w-2xl">
            <h2 class="text-2xl mb-4">Your Cart</h2>
            <div id="cartItems" class="mb-4"></div>
            <div class="flex justify-between items-center">
                <div class="text-xl">Total: $<span id="cartTotal">0</span></div>
                <button onclick="checkout()" class="px-6 py-3 bg-black text-white rounded hover:bg-gray-800">Checkout</button>
            </div>
            <button onclick="closeCart()" class="absolute top-4 right-4 text-2xl">&times;</button>
        </div>
    </div>

    <script>
        let cart = {};
        const stripe = Stripe('your_publishable_key');

        function addToCart(productId) {
            const quantity = parseInt(document.querySelector(`.quantity-input[data-id="${productId}"]`).value);
            cart[productId] = (cart[productId] || 0) + quantity;
            updateCartButton();
            showSuccessNotification();
        }

        function updateCartButton() {
            const total = Object.values(cart).reduce((a, b) => a + b, 0);
            document.getElementById('cartButton').textContent = `Cart (${total})`;
        }

        function showSuccessNotification() {
            const notification = document.getElementById('successNotification');
            notification.classList.remove('opacity-0');
            notification.classList.add('opacity-100');
            setTimeout(() => {
                notification.classList.remove('opacity-100');
                notification.classList.add('opacity-0');
            }, 2000);
        }

        document.getElementById('cartButton').addEventListener('click', () => {
            document.getElementById('cartModal').classList.remove('hidden');
            updateCartModal();
        });

        function closeCart() {
            document.getElementById('cartModal').classList.add('hidden');
        }

        function updateCartModal() {
            fetch('get-cart-items.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(cart)
            })
            .then(response => response.json())
            .then(data => {
                document.getElementById('cartItems').innerHTML = data.items;
                document.getElementById('cartTotal').textContent = data.total;
            });
        }

        function checkout() {
            fetch('create-checkout-session.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(cart)
            })
            .then(response => response.json())
            .then(session => {
                stripe.redirectToCheckout({ sessionId: session.id });
            });
        }
    </script>
</body>
</html>