<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once 'db.php';

try {
    $stmt = $pdo->prepare("
        SELECT 
            id,
            name,
            slug,
            description,
            long_description,
            price,
            price_type,
            category,
            icon_url,
            icon_fallback,
            icon_gradient,
            download_url,
            purchase_url,
            downloads,
            rating,
            rating_count,
            version,
            size_mb,
            requirements,
            featured,
            has_in_app_purchases,
            status,
            created_at,
            updated_at
        FROM apps 
        WHERE status = 'active' 
        ORDER BY 
            CASE WHEN category = 'made_by_imators' THEN 0 ELSE 1 END,
            featured DESC,
            downloads DESC,
            created_at DESC
    ");
    
    $stmt->execute();
    $apps = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode($apps);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}