<?php

include '../security/secure.php';

?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Les Fractions et les Nombres Décimaux</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Comic Sans MS', 'Arial', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            min-height: 100vh;
        }

        .container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }

        h1 {
            text-align: center;
            color: #667eea;
            font-size: 2.5em;
            margin-bottom: 30px;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.1);
        }

        .section {
            margin-bottom: 40px;
            padding: 25px;
            background: #f8f9ff;
            border-radius: 15px;
            border-left: 5px solid #667eea;
        }

        h2 {
            color: #764ba2;
            margin-bottom: 20px;
            font-size: 1.8em;
        }

        .exemple {
            background: white;
            padding: 20px;
            border-radius: 10px;
            margin: 15px 0;
            border: 3px dashed #667eea;
        }

        .etapes {
            display: flex;
            justify-content: space-around;
            margin: 20px 0;
            flex-wrap: wrap;
        }

        .etape {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            padding: 20px;
            border-radius: 15px;
            margin: 10px;
            flex: 1;
            min-width: 200px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }

        .etape-number {
            background: white;
            color: #667eea;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 10px;
            font-weight: bold;
            font-size: 1.3em;
        }

        .fraction {
            font-size: 2em;
            text-align: center;
            margin: 15px 0;
            color: #667eea;
            font-weight: bold;
        }

        .exercice {
            background: #fff9e6;
            padding: 20px;
            border-radius: 10px;
            margin: 15px 0;
            border: 2px solid #ffd700;
        }

        .exercice h3 {
            color: #ff6b6b;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
        }

        .exercice h3::before {
            content: "✏️";
            margin-right: 10px;
            font-size: 1.3em;
        }

        input {
            width: 100px;
            padding: 8px;
            border: 2px solid #667eea;
            border-radius: 5px;
            font-size: 1.1em;
            text-align: center;
            margin: 0 5px;
        }

        button {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            border: none;
            padding: 12px 30px;
            border-radius: 25px;
            font-size: 1.1em;
            cursor: pointer;
            margin-top: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
            transition: transform 0.2s;
        }

        button:hover {
            transform: translateY(-2px);
            box-shadow: 0 7px 20px rgba(0,0,0,0.3);
        }

        .resultat {
            margin-top: 15px;
            padding: 15px;
            border-radius: 8px;
            font-weight: bold;
            display: none;
        }

        .correct {
            background: #d4edda;
            color: #155724;
            border: 2px solid #28a745;
        }

        .incorrect {
            background: #f8d7da;
            color: #721c24;
            border: 2px solid #dc3545;
        }

        .astuce {
            background: #e7f3ff;
            border-left: 5px solid #2196F3;
            padding: 15px;
            margin: 15px 0;
            border-radius: 5px;
        }

        .astuce::before {
            content: "💡 ";
            font-size: 1.3em;
        }

        .visual-fraction {
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 20px 0;
        }

        .fraction-display {
            display: inline-flex;
            flex-direction: column;
            align-items: center;
            margin: 0 10px;
        }

        .numerateur, .denominateur {
            padding: 10px 20px;
            font-size: 1.8em;
            font-weight: bold;
            color: #667eea;
        }

        .fraction-bar {
            width: 100%;
            height: 3px;
            background: #667eea;
            margin: 5px 0;
        }

        .arrow {
            font-size: 2em;
            color: #764ba2;
            margin: 0 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🎨 Les Fractions et les Nombres Décimaux 🎨</h1>

        <div class="section">
            <h2>📚 Qu'est-ce qu'une fraction ?</h2>
            <div class="exemple">
                <p style="font-size: 1.2em; text-align: center; margin-bottom: 20px;">
                    Imagine une pizza coupée en <strong>4 parts égales</strong>. Si tu en prends <strong>1 part</strong>, tu as :
                </p>
                <div class="visual-fraction">
                    <div class="fraction-display">
                        <div class="numerateur">1</div>
                        <div class="fraction-bar"></div>
                        <div class="denominateur">4</div>
                    </div>
                    <div class="arrow">→</div>
                    <div style="font-size: 2em; color: #764ba2; font-weight: bold;">0,25</div>
                </div>
                <p style="text-align: center; margin-top: 15px; color: #666;">
                    <strong>1/4</strong> (un quart) = <strong>0,25</strong>
                </p>
            </div>
        </div>

        <div class="section">
            <h2>🔄 Comment transformer une fraction en nombre décimal ?</h2>
            <div class="etapes">
                <div class="etape">
                    <div class="etape-number">1</div>
                    <p>Trouve une fraction équivalente avec 10, 100 ou 1000 au dénominateur</p>
                </div>
                <div class="etape">
                    <div class="etape-number">2</div>
                    <p>Utilise cette nouvelle fraction pour écrire le nombre décimal</p>
                </div>
            </div>

            <div class="exemple">
                <h3 style="color: #667eea;">Exemple : 1/4</h3>
                <div class="visual-fraction">
                    <div class="fraction-display">
                        <div class="numerateur">1</div>
                        <div class="fraction-bar"></div>
                        <div class="denominateur">4</div>
                    </div>
                    <div class="arrow">×25 →</div>
                    <div class="fraction-display">
                        <div class="numerateur">25</div>
                        <div class="fraction-bar"></div>
                        <div class="denominateur">100</div>
                    </div>
                    <div class="arrow">=</div>
                    <div style="font-size: 2em; color: #764ba2; font-weight: bold;">0,25</div>
                </div>
            </div>

            <div class="astuce">
                <strong>Astuce :</strong> Pour avoir 100 au dénominateur à partir de 4, on multiplie par 25 ! N'oublie pas de multiplier aussi le numérateur.
            </div>
        </div>

        <div class="section">
            <h2>✨ Fractions simples à retenir</h2>
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-top: 20px;">
                <div class="exemple">
                    <div class="fraction">1/2 = 0,5</div>
                    <p style="text-align: center;">la moitié</p>
                </div>
                <div class="exemple">
                    <div class="fraction">1/4 = 0,25</div>
                    <p style="text-align: center;">le quart</p>
                </div>
                <div class="exemple">
                    <div class="fraction">3/4 = 0,75</div>
                    <p style="text-align: center;">trois quarts</p>
                </div>
                <div class="exemple">
                    <div class="fraction">1/5 = 0,2</div>
                    <p style="text-align: center;">un cinquième</p>
                </div>
                <div class="exemple">
                    <div class="fraction">1/10 = 0,1</div>
                    <p style="text-align: center;">un dixième</p>
                </div>
                <div class="exemple">
                    <div class="fraction">1/100 = 0,01</div>
                    <p style="text-align: center;">un centième</p>
                </div>
            </div>
        </div>

        <div class="section">
            <h2>🎯 Exercices pratiques</h2>

            <div class="exercice">
                <h3>Exercice 1 : Transforme ces fractions en nombres décimaux</h3>
                <p>2/10 = <input type="text" id="ex1_1" placeholder="?"></p>
                <p>6/10 = <input type="text" id="ex1_2" placeholder="?"></p>
                <p>3/4 = <input type="text" id="ex1_3" placeholder="?"></p>
                <button onclick="verifier1()">Vérifier mes réponses</button>
                <div id="result1" class="resultat"></div>
            </div>

            <div class="exercice">
                <h3>Exercice 2 : Transforme ces nombres décimaux en fractions</h3>
                <p>0,4 = <input type="text" id="ex2_1" placeholder="?"> / 10</p>
                <p>0,08 = <input type="text" id="ex2_2" placeholder="?"> / 100</p>
                <p>0,9 = <input type="text" id="ex2_3" placeholder="?"> / 10</p>
                <button onclick="verifier2()">Vérifier mes réponses</button>
                <div id="result2" class="resultat"></div>
            </div>

            <div class="exercice">
                <h3>Exercice 3 : Complète</h3>
                <p>1/2 = <input type="text" id="ex3_1" placeholder="?"></p>
                <p>0,5 = <input type="text" id="ex3_2" placeholder="?"> / 10</p>
                <p>1/5 = <input type="text" id="ex3_3" placeholder="?"></p>
                <button onclick="verifier3()">Vérifier mes réponses</button>
                <div id="result3" class="resultat"></div>
            </div>
        </div>

        <div class="astuce" style="background: #fff3cd; border-color: #ffc107;">
            <strong>💪 Bravo pour ton travail !</strong> Plus tu t'entraînes, plus ce sera facile !
        </div>
    </div>

    <script>
        function verifier1() {
            const answers = {
                ex1_1: '0.2',
                ex1_2: '0.6',
                ex1_3: '0.75'
            };
            
            let correct = 0;
            let total = 3;
            
            for (let key in answers) {
                const input = document.getElementById(key).value.replace(',', '.');
                if (input === answers[key]) {
                    correct++;
                }
            }
            
            const result = document.getElementById('result1');
            result.style.display = 'block';
            
            if (correct === total) {
                result.className = 'resultat correct';
                result.innerHTML = '🎉 Excellent ! Toutes tes réponses sont correctes ! Tu es un champion !';
            } else {
                result.className = 'resultat incorrect';
                result.innerHTML = `💪 Tu as ${correct} bonne(s) réponse(s) sur ${total}. Réessaie ! Astuce : 2/10 = 0,2 et 6/10 = 0,6 et 3/4 = 75/100 = 0,75`;
            }
        }

        function verifier2() {
            const answers = {
                ex2_1: '4',
                ex2_2: '8',
                ex2_3: '9'
            };
            
            let correct = 0;
            let total = 3;
            
            for (let key in answers) {
                const input = document.getElementById(key).value;
                if (input === answers[key]) {
                    correct++;
                }
            }
            
            const result = document.getElementById('result2');
            result.style.display = 'block';
            
            if (correct === total) {
                result.className = 'resultat correct';
                result.innerHTML = '🎉 Parfait ! Tu as tout compris !';
            } else {
                result.className = 'resultat incorrect';
                result.innerHTML = `💪 Tu as ${correct} bonne(s) réponse(s) sur ${total}. Réessaie ! Astuce : 0,4 = 4/10 et 0,08 = 8/100 et 0,9 = 9/10`;
            }
        }

        function verifier3() {
            const answers = {
                ex3_1: '0.5',
                ex3_2: '5',
                ex3_3: '0.2'
            };
            
            let correct = 0;
            let total = 3;
            
            for (let key in answers) {
                const input = document.getElementById(key).value.replace(',', '.');
                if (input === answers[key]) {
                    correct++;
                }
            }
            
            const result = document.getElementById('result3');
            result.style.display = 'block';
            
            if (correct === total) {
                result.className = 'resultat correct';
                result.innerHTML = '🎉 Extraordinaire ! Tu maîtrises parfaitement les fractions !';
            } else {
                result.className = 'resultat incorrect';
                result.innerHTML = `💪 Tu as ${correct} bonne(s) réponse(s) sur ${total}. Continue ! Astuce : 1/2 = 0,5 et 0,5 = 5/10 et 1/5 = 2/10 = 0,2`;
            }
        }
    </script>
</body>
</html>