<?php
require_once 'config.php';

$code = isset($_GET['code']) ? $_GET['code'] : '';

if (empty($code)) {
    header('Location: /index.php?error=invalid_code');
    exit;
}

// Vérifier si le code d'invitation est valide
$stmt = $db->prepare("SELECT i.*, f.family_name FROM family_invites i 
                     JOIN families f ON i.family_id = f.id
                     WHERE i.invite_code = ? AND i.accepted = 0 
                     AND i.created_at > DATE_SUB(NOW(), INTERVAL 7 DAY)");
$stmt->execute([$code]);
$invite = $stmt->fetch();

if (!$invite) {
    header('Location: /index.php?error=expired_code');
    exit;
}

$error = '';
$success = false;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = isset($_POST['username']) ? trim($_POST['username']) : '';
    $email = isset($_POST['email']) ? trim($_POST['email']) : $invite['email'];
    $password = isset($_POST['password']) ? $_POST['password'] : '';
    $confirm_password = isset($_POST['confirm_password']) ? $_POST['confirm_password'] : '';
    
    if (empty($username) || empty($password) || empty($confirm_password)) {
        $error = 'All fields are required.';
    } elseif ($password != $confirm_password) {
        $error = 'Passwords do not match.';
    } elseif (strlen($password) < 8) {
        $error = 'Password must be at least 8 characters.';
    } else {
        // Vérifier si l'utilisateur existe déjà
        $stmt = $db->prepare("SELECT id FROM users WHERE email = ?");
        $stmt->execute([$email]);
        $existing_user = $stmt->fetch();
        
        if ($existing_user) {
            // L'utilisateur existe déjà, lui connecter à cette famille
            $user_id = $existing_user['id'];
            
            // Vérifier si l'utilisateur est déjà membre de cette famille
            $stmt = $db->prepare("SELECT id FROM family_members WHERE user_id = ? AND family_id = ?");
            $stmt->execute([$user_id, $invite['family_id']]);
            
            if ($stmt->rowCount() == 0) {
                // Ajouter l'utilisateur à la famille
                $stmt = $db->prepare("INSERT INTO family_members (family_id, user_id, role, joined_at) 
                                     VALUES (?, ?, 'member', NOW())");
                $stmt->execute([$invite['family_id'], $user_id]);
                
                // Marquer l'invitation comme acceptée
                $stmt = $db->prepare("UPDATE family_invites SET accepted = 1, accepted_at = NOW() WHERE id = ?");
                $stmt->execute([$invite['id']]);
                
                // Connecter l'utilisateur
                $_SESSION['user_id'] = $user_id;
                $_SESSION['username'] = $username;
                $_SESSION['family_id'] = $invite['family_id'];
                
                $success = true;
            } else {
                $error = 'You are already a member of this family.';
            }
        } else {
            // Créer un nouvel utilisateur
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            
            try {
                $db->beginTransaction();
                
                // Insérer l'utilisateur
                $stmt = $db->prepare("INSERT INTO users (username, email, password, created_at) 
                                     VALUES (?, ?, ?, NOW())");
                $stmt->execute([$username, $email, $hashed_password]);
                $user_id = $db->lastInsertId();
                
                // Ajouter l'utilisateur à la famille
                $stmt = $db->prepare("INSERT INTO family_members (family_id, user_id, role, joined_at) 
                                     VALUES (?, ?, 'member', NOW())");
                $stmt->execute([$invite['family_id'], $user_id]);
                
                // Marquer l'invitation comme acceptée
                $stmt = $db->prepare("UPDATE family_invites SET accepted = 1, accepted_at = NOW() WHERE id = ?");
                $stmt->execute([$invite['id']]);
                
                $db->commit();
                
                // Connecter l'utilisateur
                $_SESSION['user_id'] = $user_id;
                $_SESSION['username'] = $username;
                $_SESSION['family_id'] = $invite['family_id'];
                
                $success = true;
            } catch (Exception $e) {
                $db->rollBack();
                $error = 'An error occurred. Please try again.';
                // Log l'erreur pour le débogage
                error_log($e->getMessage());
            }
        }
    }
    
    if ($success) {
        header('Location: /index.php?page=home');
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Join Family - AndWeare</title>
    <link rel="icon" type="image/png" href="/assets/images/logo.png">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+KR:wght@300;400;500;700&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#f0f9ff',
                            100: '#e0f2fe',
                            500: '#0ea5e9',
                            600: '#0284c7',
                            700: '#0369a1'
                        }
                    }
                }
            }
        }
    </script>
    <style>
        body {
            font-family: 'Noto Sans KR', sans-serif;
            background-color: #f0f9ff;
        }
    </style>
</head>
<body class="min-h-screen flex items-center justify-center p-4">
    <div class="w-full max-w-md">
        <div class="text-center mb-8">
            <img src="/assets/images/logo.png" alt="AndWeare Logo" class="h-12 mx-auto mb-4">
            <h1 class="text-2xl font-medium text-gray-900">Join the <?php echo htmlspecialchars($invite['family_name']); ?> Family</h1>
            <p class="text-gray-600 mt-2">Create your account to connect with your family</p>
        </div>
        
        <div class="bg-white rounded-lg shadow-md p-8">
            <?php if ($error): ?>
            <div class="mb-6 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
                <p><?php echo $error; ?></p>
            </div>
            <?php endif; ?>
            
            <form method="post" action="">
                <div class="mb-4">
                    <label for="email" class="block text-sm font-medium text-gray-700 mb-1">Email Address</label>
                    <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($invite['email']); ?>" 
                        readonly class="w-full px-3 py-2 border border-gray-300 bg-gray-100 rounded-md">
                </div>
                
                <div class="mb-4">
                    <label for="username" class="block text-sm font-medium text-gray-700 mb-1">Your Name</label>
                    <input type="text" id="username" name="username" required 
                        class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-primary-500">
                </div>
                
                <div class="mb-4">
                    <label for="password" class="block text-sm font-medium text-gray-700 mb-1">Password</label>
                    <input type="password" id="password" name="password" required 
                        class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-primary-500">
                </div>
                
                <div class="mb-6">
                    <label for="confirm_password" class="block text-sm font-medium text-gray-700 mb-1">Confirm Password</label>
                    <input type="password" id="confirm_password" name="confirm_password" required 
                        class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-primary-500">
                </div>
                
                <button type="submit" class="w-full bg-primary-600 hover:bg-primary-700 text-white font-medium py-2 px-4 rounded-md transition">
                    Join Family
                </button>
            </form>
            
            <div class="mt-6 text-center text-sm text-gray-600">
                <p>Already have an account? <a href="/index.php" class="text-primary-600 hover:text-primary-700">Sign in</a></p>
            </div>
        </div>
        
        <div class="mt-6 text-center text-sm text-gray-500">
            &copy; <?php echo date('Y'); ?> AndWeare - A product by Imators
        </div>
    </div>
    
    <script>
        console.log('Invitation code:', '<?php echo $code; ?>');
        console.log('Family name:', '<?php echo addslashes($invite['family_name']); ?>');
        console.log('Email:', '<?php echo addslashes($invite['email']); ?>');
    </script>
</body>
</html>