<?php
require_once '../db.php';

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($id <= 0) {
    header('Location: ../database-directory.php');
    exit;
}

if ($_POST) {
    $titre = $_POST['titre'];
    $description = $_POST['description'];
    $secteurs = $_POST['secteurs'];
    $statut = $_POST['statut'];
    $date_ouverture = $_POST['date_ouverture'];
    $date_fermeture = !empty($_POST['date_fermeture']) ? $_POST['date_fermeture'] : null;
    
    $stmt = $pdo->prepare("UPDATE dossiers SET titre = ?, description = ?, secteurs = ?, statut = ?, date_ouverture = ?, date_fermeture = ? WHERE id = ?");
    $stmt->execute([$titre, $description, $secteurs, $statut, $date_ouverture, $date_fermeture, $id]);
    
    header('Location: ../database-directory.php');
    exit;
}

$stmt = $pdo->prepare("SELECT * FROM dossiers WHERE id = ?");
$stmt->execute([$id]);
$dossier = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$dossier) {
    header('Location: ../database-directory.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>The Lord Court - Edit Case</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Inter:wght@300;400&display=swap" rel="stylesheet">
    <style>
        .playfair {
            font-family: 'Playfair Display', serif;
        }
        .inter-light {
            font-family: 'Inter', sans-serif;
            font-weight: 300;
        }
    </style>
</head>
<body class="bg-white">
    <header class="bg-white border-b border-black fixed top-0 left-0 right-0 z-50">
        <div class="max-w-7xl mx-auto px-8 py-6 flex justify-between items-center">
            <h1 class="playfair text-3xl text-black">THE LORD COURT</h1>
            <a href="database-directory.php" class="inter-light text-black hover:text-gray-600 transition-colors">← Back to cases</a>
        </div>
    </header>
    <main class="pt-24">
        <section class="max-w-7xl mx-auto px-8 py-20">
            <div class="max-w-4xl">
                <h2 class="playfair text-5xl mb-6 text-black">Edit Case</h2>
                <form method="POST" class="space-y-8">
                    <div class="grid md:grid-cols-2 gap-8">
                        <div>
                            <label class="inter-light text-lg text-black block mb-2">Case title</label>
                            <input type="text" name="titre" value="<?php echo htmlspecialchars($dossier['titre']); ?>" required class="w-full p-4 border border-black inter-light text-lg">
                        </div>
                        <div>
                            <label class="inter-light text-lg text-black block mb-2">Affected sectors</label>
                            <input type="text" name="secteurs" value="<?php echo htmlspecialchars($dossier['secteurs']); ?>" class="w-full p-4 border border-black inter-light text-lg" placeholder="E.g. Cybercrime, Fraud">
                        </div>
                    </div>
                    
                    <div>
                        <label class="inter-light text-lg text-black block mb-2">Case description</label>
                        <textarea name="description" rows="6" class="w-full p-4 border border-black inter-light text-lg"><?php echo htmlspecialchars($dossier['description']); ?></textarea>
                    </div>
                    
                    <div class="grid md:grid-cols-3 gap-8">
                        <div>
                            <label class="inter-light text-lg text-black block mb-2">Status</label>
                            <select name="statut" class="w-full p-4 border border-black inter-light text-lg">
                                <option value="ouvert" <?php echo $dossier['statut'] === 'ouvert' ? 'selected' : ''; ?>>Open</option>
                                <option value="ferme" <?php echo $dossier['statut'] === 'ferme' ? 'selected' : ''; ?>>Closed</option>
                            </select>
                        </div>
                        <div>
                            <label class="inter-light text-lg text-black block mb-2">Opening date</label>
                            <input type="date" name="date_ouverture" value="<?php echo $dossier['date_ouverture']; ?>" required class="w-full p-4 border border-black inter-light text-lg">
                        </div>
                        <div>
                            <label class="inter-light text-lg text-black block mb-2">Closing date</label>
                            <input type="date" name="date_fermeture" value="<?php echo $dossier['date_fermeture']; ?>" class="w-full p-4 border border-black inter-light text-lg">
                        </div>
                    </div>
                    
                    <div class="flex gap-4">
                        <button type="submit" class="px-8 py-4 bg-black text-white inter-light text-lg hover:bg-gray-800 transition-colors">Update case</button>
                        <a href="database-directory.php" class="px-8 py-4 border border-black text-black inter-light text-lg hover:bg-gray-100 transition-colors">Cancel</a>
                    </div>
                </form>
            </div>
        </section>
    </main>
</body>
</html>