<?php
session_start();
include 'db.php';

header('Content-Type: application/json');

if (!isset($_SESSION['resident_id'])) {
    echo json_encode(['success' => false, 'error' => 'Non autorisé']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$plan = $input['plan'] ?? '';
$transaction_id = $input['transaction_id'] ?? '';
$receipt = $input['receipt'] ?? '';

if (empty($plan) || empty($transaction_id) || empty($receipt)) {
    echo json_encode(['success' => false, 'error' => 'Données manquantes']);
    exit;
}

$resident_id = $_SESSION['resident_id'];

function verifyAppleReceipt($receipt) {
    $receipt_data = [
        'receipt-data' => $receipt,
        'password' => 'e80d9d15c51841f7939ea637e806f95c'
    ];
    
    $production_url = 'https://buy.itunes.apple.com/verifyReceipt';
    $sandbox_url = 'https://sandbox.itunes.apple.com/verifyReceipt';
    
    $ch = curl_init($production_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($receipt_data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json'
    ]);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code !== 200) {
        return false;
    }
    
    $data = json_decode($response, true);
    
    if ($data['status'] == 21007) {
        $ch = curl_init($sandbox_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($receipt_data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json'
        ]);
        
        $response = curl_exec($ch);
        curl_close($ch);
        
        $data = json_decode($response, true);
    }
    
    return $data['status'] === 0 ? $data : false;
}

try {
    $verification = verifyAppleReceipt($receipt);
    
    if (!$verification) {
        echo json_encode(['success' => false, 'error' => 'Reçu Apple invalide']);
        exit;
    }
    
    $conn->autocommit(false);
    
    $stmt = $conn->prepare("SELECT * FROM residents WHERE id = ?");
    $stmt->bind_param("i", $resident_id);
    $stmt->execute();
    $resident = $stmt->get_result()->fetch_assoc();
    
    if (!$resident) {
        throw new Exception('Utilisateur non trouvé');
    }
    
    if (($plan === 'member' && $resident['member_'] == 1) || 
        ($plan === 'premium' && $resident['premium_'] == 1)) {
        throw new Exception('Déjà abonné à ce plan');
    }
    
    $subscription_end = date('Y-m-d H:i:s', strtotime('+1 month'));
    $amount = $plan === 'member' ? 1.99 : 9.99;
    
    if ($plan === 'member') {
        $stmt = $conn->prepare("UPDATE residents SET member_ = 1, member_subscription_end = ? WHERE id = ?");
        $stmt->bind_param("si", $subscription_end, $resident_id);
    } else {
        $stmt = $conn->prepare("UPDATE residents SET premium_ = 1, premium_subscription_end = ? WHERE id = ?");
        $stmt->bind_param("si", $subscription_end, $resident_id);
    }
    
    if (!$stmt->execute()) {
        throw new Exception('Erreur lors de la mise à jour du profil');
    }
    
    $stmt = $conn->prepare("INSERT INTO apple_transactions (resident_id, plan, transaction_id, amount, receipt_data, created_at) VALUES (?, ?, ?, ?, ?, NOW())");
    $stmt->bind_param("issds", $resident_id, $plan, $transaction_id, $amount, $receipt);
    
    if (!$stmt->execute()) {
        throw new Exception('Erreur lors de l\'enregistrement de la transaction');
    }
    
    $stmt = $conn->prepare("INSERT INTO subscription_history (resident_id, plan_type, start_date, end_date, payment_method, transaction_id, amount, status) VALUES (?, ?, NOW(), ?, 'apple_pay', ?, ?, 'active')");
    $stmt->bind_param("isssd", $resident_id, $plan, $subscription_end, $transaction_id, $amount);
    
    if (!$stmt->execute()) {
        throw new Exception('Erreur lors de l\'enregistrement de l\'historique');
    }
    
    $conn->commit();
    
    $subject = "Confirmation d'abonnement Vert Chasseur";
    $plan_title = $plan === 'member' ? 'Membre Vert Chasseur' : 'Membre Vert+ Chasseur';
    $price = $plan === 'member' ? '1,99€' : '9,99€';
    
    $message = "
    <html>
    <head>
        <style>
            body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background: #16a34a; color: white; padding: 20px; border-radius: 8px 8px 0 0; }
            .content { background: white; padding: 20px; border: 1px solid #e5e7eb; }
            .footer { background: #f9fafb; padding: 15px; border-radius: 0 0 8px 8px; font-size: 12px; color: #6b7280; }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h1>Merci pour ton abonnement !</h1>
            </div>
            <div class='content'>
                <h2>Bonjour " . htmlspecialchars($resident['first_name']) . ",</h2>
                <p>Ton abonnement <strong>" . $plan_title . "</strong> a été activé avec succès.</p>
                <ul>
                    <li><strong>Plan :</strong> " . $plan_title . "</li>
                    <li><strong>Prix :</strong> " . $price . "/mois</li>
                    <li><strong>Fin d'abonnement :</strong> " . date('d/m/Y', strtotime($subscription_end)) . "</li>
                    <li><strong>Méthode de paiement :</strong> Apple Pay</li>
                </ul>
                <p>Tu peux gérer ton abonnement depuis ton espace personnel sur l'application.</p>
            </div>
            <div class='footer'>
                <p>Cet email est envoyé automatiquement par Vert Chasseur - Imators</p>
            </div>
        </div>
    </body>
    </html>
    ";
    
    $headers = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type: text/html; charset=utf-8\r\n";
    $headers .= "From: noreply@vertchasseur.com\r\n";
    
    mail($resident['email'], $subject, $message, $headers);
    
    echo json_encode([
        'success' => true,
        'message' => 'Abonnement activé avec succès',
        'plan' => $plan,
        'end_date' => $subscription_end
    ]);
    
} catch (Exception $e) {
    $conn->rollback();
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
} finally {
    $conn->autocommit(true);
}
?>