<?php
session_start();
include 'db.php';

if (!isset($_SESSION['resident_id'])) {
    header('Location: login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Carte Apple Wallet - Vert Chasseur</title>
    <link rel="icon" type="image/png" href="logo_new.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {}
            }
        }
    </script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&display=swap" rel="stylesheet">
    <style>
        @media (min-width: 768px) {
            body {
                background-image: url('font-homepage.png');
                background-size: cover;
                background-position: center;
                background-attachment: fixed;
                background-repeat: no-repeat;
            }
        }
        @media (max-width: 767px) {
            body {
                background-color: #ffffff !important;
                background-image: none !important;
            }
            .dark body {
                background-color: #000000 !important;
                background-image: none !important;
            }
        }
        body {
            font-family: 'Inter', sans-serif;
        }
        .txt-chasseur {
            font-family: "Princess Sofia", serif;
            font-weight: 400;
        }
        
        .wallet-card {
            background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
            position: relative;
            overflow: hidden;
        }
        
        .wallet-card::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
            transform: rotate(45deg);
        }
        
        .logo-corner {
            position: absolute;
            bottom: 20px;
            right: 20px;
            width: 40px;
            height: 40px;
            background: rgba(255,255,255,0.9);
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            color: #2c3e50;
            font-size: 12px;
        }
        
        .success-modal {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 9999;
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }
        
        .success-modal.show {
            opacity: 1;
            visibility: visible;
        }
        
        .success-content {
            background: white;
            border-radius: 1rem;
            max-width: 90vw;
            max-height: 90vh;
            overflow-y: auto;
            transform: scale(0.9);
            transition: transform 0.3s ease;
        }
        
        .dark .success-content {
            background: #1c1917;
        }
        
        .success-modal.show .success-content {
            transform: scale(1);
        }
    </style>
</head>
<body class="bg-white dark:bg-black transition-colors duration-300">
    <script>
        if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
            document.documentElement.classList.add('dark');
        } else {
            document.documentElement.classList.remove('dark');
        }
    </script>

    <main class="min-h-screen px-4 py-8 md:py-16">
        <div class="max-w-4xl mx-auto">
            <div class="flex flex-col items-center justify-center mb-8 md:mb-12 text-center">
                <a href="index.php" class="absolute top-8 left-8 p-2 text-stone-600 dark:text-stone-400 hover:text-stone-800 dark:hover:text-stone-200 transition-colors">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                    </svg>
                </a>
                
                <h1 class="text-3xl md:text-5xl lg:text-6xl font-light text-stone-800 dark:text-white mb-2 md:mb-3 tracking-tight">
                    Carte Apple Wallet
                </h1>
                <p class="text-lg md:text-xl text-stone-600 dark:text-stone-400 font-light">
                    Génère ta carte de résident <span class="txt-chasseur text-green-600">Vert Chasseur</span>
                </p>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 md:gap-12">
                <div class="bg-white dark:bg-stone-900 rounded-2xl md:rounded-3xl p-6 md:p-8 border border-stone-200 dark:border-stone-800 shadow-lg dark:shadow-stone-900/30">
                    <h2 class="text-2xl md:text-3xl font-light text-stone-800 dark:text-white mb-6 md:mb-8 tracking-tight">
                        Génération automatique
                    </h2>
                    
                    <div class="space-y-6">
                        <div class="bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 p-4 rounded-xl">
                            <div class="flex items-center space-x-3">
                                <svg class="w-5 h-5 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                <span class="text-green-800 dark:text-green-200 font-medium">Tes informations sont déjà prêtes</span>
                            </div>
                        </div>
                        
                        <form id="walletForm" method="POST" action="generate_wallet_pass.php">
                            <input type="hidden" name="action" value="generate_wallet">
                            
                            <div class="space-y-4 text-stone-600 dark:text-stone-400 mb-6">
                                <div class="flex items-start space-x-3">
                                    <div class="w-2 h-2 bg-green-500 rounded-full mt-2 flex-shrink-0"></div>
                                    <p>Ta carte sera générée avec tes informations de profil</p>
                                </div>
                                <div class="flex items-start space-x-3">
                                    <div class="w-2 h-2 bg-green-500 rounded-full mt-2 flex-shrink-0"></div>
                                    <p>Compatible avec tous les appareils Apple</p>
                                </div>
                                <div class="flex items-start space-x-3">
                                    <div class="w-2 h-2 bg-green-500 rounded-full mt-2 flex-shrink-0"></div>
                                    <p>Ajout automatique à Apple Wallet</p>
                                </div>
                            </div>
                            
                            <button type="submit" 
                                    class="w-full bg-gradient-to-r from-green-600 to-emerald-600 hover:from-green-700 hover:to-emerald-700 text-white font-medium py-4 px-6 rounded-xl transition-all duration-200 transform hover:scale-105">
                                <div class="flex items-center justify-center space-x-2">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z"/>
                                    </svg>
                                    <span>Générer ma carte Apple Wallet</span>
                                </div>
                            </button>
                        </form>
                    </div>
                </div>
                
                <div class="space-y-6">
                    <div class="bg-white dark:bg-stone-900 rounded-2xl md:rounded-3xl p-6 md:p-8 border border-stone-200 dark:border-stone-800 shadow-lg dark:shadow-stone-900/30">
                        <h3 class="text-xl md:text-2xl font-light text-stone-800 dark:text-white mb-4 tracking-tight">
                            Aperçu de ta carte
                        </h3>
                        
                        <div class="wallet-card text-white rounded-xl p-6 relative min-h-48">
                            <div class="relative z-10">
                                <div class="flex justify-between items-start mb-6">
                                    <div>
                                        <div id="preview-name" class="text-xl font-bold mb-1">Ton nom</div>
                                        <div class="text-sm opacity-90">Résident du Quartier</div>
                                    </div>
                                    <div id="preview-member-since" class="text-right text-sm opacity-90">
                                        Membre depuis<br>
                                        <span class="font-medium">--</span>
                                    </div>
                                </div>
                                
                                <div class="flex items-center space-x-4 mt-8">
                                    <div class="w-12 h-12 bg-white/20 rounded-lg flex items-center justify-center">
                                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2H5a2 2 0 00-2-2v0"/>
                                        </svg>
                                    </div>
                                    <div>
                                        <div class="font-medium">Carte Résident</div>
                                        <div class="text-sm opacity-75">Vert Chasseur</div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="logo-corner">
                                <img src="logo_new.png" alt="Vert Chasseur" style="width: 100%; height: 100%; object-fit: contain; border-radius: 6px;">
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-amber-50 dark:bg-amber-900/20 rounded-2xl p-6 border border-amber-200 dark:border-amber-800">
                        <div class="flex items-start space-x-3">
                            <svg class="w-5 h-5 text-amber-600 dark:text-amber-400 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            <div>
                                <h4 class="font-medium text-amber-800 dark:text-amber-200 mb-1">À propos des cartes Apple Wallet</h4>
                                <p class="text-sm text-amber-700 dark:text-amber-300">
                                    Cette carte sera ajoutée à ton Apple Wallet et pourra être utilisée pour les offres exclusives du quartier.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <footer class="w-full py-4 md:py-6 border-t border-stone-200 dark:border-stone-800 mt-16">
        <p class="text-xs text-stone-500 dark:text-stone-400 text-center px-4">
            © 2025 Vert Chasseur · 
            <a href="https://aktascorp.com" class="underline hover:text-stone-700 dark:hover:text-stone-300">aktascorp</a> member
        </p>
    </footer>

    <script>
        function loadUserData() {
            fetch('get_user_data.php')
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        document.getElementById('preview-name').textContent = data.first_name + ' ' + data.last_name;
                        const memberDate = new Date(data.created_at);
                        const memberSince = memberDate.toLocaleDateString('fr-FR', { month: 'long', year: 'numeric' });
                        document.getElementById('preview-member-since').innerHTML = 
                            `Membre depuis<br><span class="font-medium">${memberSince}</span>`;
                    }
                })
                .catch(error => {
                    console.error('Erreur lors du chargement des données:', error);
                });
        }
        
        document.addEventListener('DOMContentLoaded', function() {
            loadUserData();
            
            document.getElementById('walletForm').addEventListener('submit', function(e) {
                const button = this.querySelector('button[type="submit"]');
                const originalContent = button.innerHTML;
                
                button.disabled = true;
                button.innerHTML = `
                    <div class="flex items-center justify-center space-x-2">
                        <svg class="animate-spin w-5 h-5" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                        <span>Génération en cours...</span>
                    </div>
                `;
                
                setTimeout(() => {
                    button.disabled = false;
                    button.innerHTML = originalContent;
                }, 3000);
            });
        });
    </script>
</body>
</html>