<?php
include 'db.php';
header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);
$deliveryTime = $input['deliveryTime'];
$date = $input['date'];

$dayOfWeek = strtolower(date('l', strtotime($date)));

$query = "SELECT l.* FROM livreur l 
          JOIN livreur_availability la ON l.id = la.livreur_id 
          WHERE l.available = 1 
          AND la.day_of_week = ? 
          AND la.start_time <= ? 
          AND la.end_time >= ? 
          AND la.active = 1 
          LIMIT 1";

$stmt = $conn->prepare($query);
$stmt->bind_param("sss", $dayOfWeek, $deliveryTime, $deliveryTime);
$stmt->execute();
$result = $stmt->get_result()->fetch_assoc();

if ($result) {
    echo json_encode([
        'available' => true,
        'deliveryPerson' => $result
    ]);
} else {
    echo json_encode(['available' => false]);
}
?>