session_start();
include 'db.php';
header('Content-Type: application/json');

// ========== CONFIGURATION STRIPE ==========
$PRODUCTION_MODE = false; // ← Changer en true pour la production

if ($PRODUCTION_MODE) {
    $stripeSecretKey = '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';
    $stripePublishableKey = 'pk_live_51LmhGsHQanXHoJn0qgKjMAisGwy6TzfZyUnzSq2Yc9qDmAQv8Syu9wuFDZVjgpg8kWUxm9bQ8MMi8E3WwNayGXus00Oe5tyNIP';
} else {
    $stripeSecretKey = 'sk_test_51LmhGsHQanXHoJn0RTN8E60pZA6VlweUCRsEKA5o0Xwnucm1UKCNRJGwUYgXXcPajVgfjRp3GgUIme0HbeSGZkR300dtVCPlyy';
    $stripePublishableKey = 'pk_test_51LmhGsHQanXHoJn0wBK5v2yQyHFdQ4KlSXSXZobDhxFPCrhVwWtCwWXvNIxjOQdi65riR24NEgQyY6Ck1UZkPqq800jtbOgNU8';
}

if (!isset($_SESSION['resident_id'])) {
    echo json_encode(['error' => 'Non connecté']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);

$subtotal = 0;
foreach ($input['items'] as $item) {
    $subtotal += $item['price'] * $item['quantity'];
}

$deliveryFee = 2.50;
$total = $subtotal + $deliveryFee;
$amountInCents = intval($total * 100);

require_once '../vendor/stripe/stripe-php/init.php';
\Stripe\Stripe::setApiKey($stripeSecretKey);

try {
    $paymentIntent = \Stripe\PaymentIntent::create([
        'amount' => $amountInCents,
        'currency' => 'eur',
        'metadata' => [
            'resident_id' => $_SESSION['resident_id'],
            'store_id' => $input['storeId'],
            'delivery_time' => $input['deliveryTime']
        ]
    ]);
    
    echo json_encode([
        'clientSecret' => $paymentIntent->client_secret,
        'publishableKey' => $stripePublishableKey
    ]);
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
?>