<?php
session_start();
header('Content-Type: application/json');

require_once 'vendor/autoload.php';
require_once 'db.php';

\Stripe\Stripe::setApiKey('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');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Méthode non autorisée']);
    exit;
}

if (!isset($_SESSION['resident_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Non authentifié']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);

if (!isset($input['payment_method_id']) || !isset($input['resident_id'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Données manquantes']);
    exit;
}

$payment_method_id = $input['payment_method_id'];
$resident_id = intval($input['resident_id']);

if ($resident_id !== $_SESSION['resident_id']) {
    http_response_code(403);
    echo json_encode(['success' => false, 'error' => 'Accès refusé']);
    exit;
}

try {
    $stmt = $conn->prepare("SELECT * FROM residents WHERE id = ?");
    $stmt->bind_param("i", $resident_id);
    $stmt->execute();
    $resident = $stmt->get_result()->fetch_assoc();
    
    if (!$resident) {
        throw new Exception("Résident non trouvé");
    }

    $check_stmt = $conn->prepare("SELECT * FROM premium_subscriptions WHERE resident_id = ? AND status = 'active' AND expires_at > NOW()");
    $check_stmt->bind_param("i", $resident_id);
    $check_stmt->execute();
    $existing = $check_stmt->get_result()->fetch_assoc();
    
    if ($existing) {
        echo json_encode(['success' => false, 'error' => 'Abonnement déjà actif']);
        exit;
    }

    $stripe_customer_id = null;
    
    $customer_stmt = $conn->prepare("SELECT stripe_customer_id FROM residents WHERE id = ?");
    $customer_stmt->bind_param("i", $resident_id);
    $customer_stmt->execute();
    $customer_result = $customer_stmt->get_result()->fetch_assoc();
    
    if ($customer_result && $customer_result['stripe_customer_id']) {
        $stripe_customer_id = $customer_result['stripe_customer_id'];
    } else {
        $customer = \Stripe\Customer::create([
            'email' => $resident['email'],
            'name' => $resident['first_name'] . ' ' . $resident['last_name'],
            'metadata' => [
                'resident_id' => $resident_id
            ]
        ]);
        
        $stripe_customer_id = $customer->id;
        
        $update_stmt = $conn->prepare("UPDATE residents SET stripe_customer_id = ? WHERE id = ?");
        $update_stmt->bind_param("si", $stripe_customer_id, $resident_id);
        $update_stmt->execute();
    }

    $payment_method = \Stripe\PaymentMethod::retrieve($payment_method_id);
    $payment_method->attach(['customer' => $stripe_customer_id]);

    $subscription = \Stripe\Subscription::create([
        'customer' => $stripe_customer_id,
        'items' => [[
            'price_data' => [
                'currency' => 'eur',
                'product_data' => [
                    'name' => 'Vert Chasseur - Membre Premium',
                    'description' => 'Abonnement mensuel premium avec réductions de 10% chez tous nos partenaires'
                ],
                'unit_amount' => 199,
                'recurring' => [
                    'interval' => 'month'
                ]
            ]
        ]],
        'default_payment_method' => $payment_method_id,
        'expand' => ['latest_invoice.payment_intent'],
        'metadata' => [
            'resident_id' => $resident_id
        ]
    ]);

    $payment_intent = $subscription->latest_invoice->payment_intent;

    if ($payment_intent->status === 'requires_action') {
        echo json_encode([
            'success' => false,
            'requires_action' => true,
            'payment_intent_client_secret' => $payment_intent->client_secret
        ]);
        exit;
    }

    if ($payment_intent->status === 'succeeded') {
        $expires_at = date('Y-m-d H:i:s', strtotime('+1 month'));
        
        $insert_stmt = $conn->prepare("INSERT INTO premium_subscriptions (resident_id, stripe_subscription_id, stripe_customer_id, status, created_at, expires_at) VALUES (?, ?, ?, 'active', NOW(), ?)");
        $insert_stmt->bind_param("isss", $resident_id, $subscription->id, $stripe_customer_id, $expires_at);
        $insert_stmt->execute();

        echo json_encode(['success' => true, 'message' => 'Abonnement créé avec succès']);
    } else {
        echo json_encode(['success' => false, 'error' => 'Paiement échoué']);
    }

} catch (\Stripe\Exception\CardException $e) {
    echo json_encode(['success' => false, 'error' => 'Carte refusée: ' . $e->getError()->message]);
} catch (\Stripe\Exception\InvalidRequestException $e) {
    echo json_encode(['success' => false, 'error' => 'Requête invalide']);
} catch (\Stripe\Exception\AuthenticationException $e) {
    echo json_encode(['success' => false, 'error' => 'Erreur d\'authentification Stripe']);
} catch (\Stripe\Exception\ApiConnectionException $e) {
    echo json_encode(['success' => false, 'error' => 'Erreur de connexion à Stripe']);
} catch (\Stripe\Exception\ApiErrorException $e) {
    echo json_encode(['success' => false, 'error' => 'Erreur API Stripe']);
} catch (Exception $e) {
    error_log("Erreur subscription: " . $e->getMessage());
    echo json_encode(['success' => false, 'error' => 'Erreur interne']);
}
?>