<?php
session_start();
include 'db.php';

header('Content-Type: application/json');

if (!isset($_SESSION['resident_id'])) {
    echo json_encode(['success' => false, 'error' => 'Non connecté']);
    exit;
}

$resident_id = $_SESSION['resident_id'];

try {
    $stmt = $conn->prepare("SELECT first_name, last_name, email, address, created_at FROM residents WHERE id = ?");
    $stmt->bind_param("i", $resident_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($resident = $result->fetch_assoc()) {
        echo json_encode([
            'success' => true,
            'first_name' => $resident['first_name'],
            'last_name' => $resident['last_name'],
            'email' => $resident['email'],
            'address' => $resident['address'],
            'created_at' => $resident['created_at']
        ]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Utilisateur introuvable']);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => 'Erreur de base de données']);
}
?>