<?php include 'tracking_header.php'; ?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="logo_new.png">
    <title>Vert Chasseur</title>    
    <meta name="description" content="Vert Chasseur est un quartier à Uccle où vous trouverez de la joie et un havre de paix accueillant. Découvrez les commerces partenaire du quartier et les événements qui pourrait vous intéresser.">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&display=swap" rel="stylesheet">
        <script defer src="https://cloud.umami.is/script.js" data-website-id="6ec552ef-4a61-4f71-a55f-4464703af623"></script>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            letter-spacing: -0.01em;
        }
        .card-hover {
            transition: transform 0.3s ease;
        }
        .card-hover:hover {
            transform: translateY(-4px);
        }
        .arrow-hover {
            transition: transform 0.3s ease;
        }
        .card-hover:hover .arrow-hover {
            transform: translateX(8px);
        }
        
        .txt-chasseur {
            font-family: "Princess Sofia", serif;
            font-weight: 400;
            font-style: normal;
        }

        .weather-widget {
            background: transparent;
            border-radius: 8px;
            padding: 8px 12px;
            color: inherit;
            cursor: pointer;
            transition: all 0.3s ease;
            position: relative;
            overflow: visible;
            display: flex;
            align-items: center;
            border: 1px solid rgba(0, 0, 0, 0.1);
        }

        .dark .weather-widget {
            border-color: rgba(255, 255, 255, 0.1);
        }

        .weather-widget:hover {
            background: rgba(0, 0, 0, 0.05);
            border-color: rgba(0, 0, 0, 0.2);
        }

        .dark .weather-widget:hover {
            background: rgba(255, 255, 255, 0.05);
            border-color: rgba(255, 255, 255, 0.2);
        }

        .weather-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 6px;
        }

        .weather-widget-container {
            position: relative;
        }

        .weather-expanded {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.6s cubic-bezier(0.4, 0, 0.2, 1), opacity 0.4s ease 0.1s;
            opacity: 0;
            background: white;
            border-radius: 8px;
            margin-top: 0;
            border: 1px solid rgba(0, 0, 0, 0.1);
            position: absolute;
            top: 100%;
            left: 0;
            right: 0;
            z-index: 40;
            min-width: 300px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .dark .weather-expanded {
            background: #000;
            border-color: rgba(255, 255, 255, 0.1);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
        }

        @media (max-width: 768px) {
            .weather-expanded {
                position: fixed;
                top: auto;
                bottom: 0;
                left: 0;
                right: 0;
                min-width: 100%;
                border-radius: 16px 16px 0 0;
                max-width: 100%;
                box-shadow: 0 -4px 12px rgba(0, 0, 0, 0.1);
            }

            .dark .weather-expanded {
                box-shadow: 0 -4px 12px rgba(0, 0, 0, 0.3);
            }

            .weather-expanded.show {
                max-height: 60vh;
                overflow-y: auto;
            }
        }

        .weather-expanded.show {
            max-height: 800px;
            opacity: 1;
            margin-top: 8px;
        }

        .weather-expanded-inner {
            padding: 16px;
        }

        .hourly-forecast {
            display: flex;
            gap: 12px;
            overflow-x: auto;
            padding: 12px 0;
            scrollbar-width: thin;
            scrollbar-color: rgba(0, 0, 0, 0.2) transparent;
        }

        .dark .hourly-forecast {
            scrollbar-color: rgba(255, 255, 255, 0.2) transparent;
        }

        .hourly-forecast::-webkit-scrollbar {
            height: 6px;
        }

        .hourly-forecast::-webkit-scrollbar-track {
            background: rgba(0, 0, 0, 0.05);
            border-radius: 3px;
        }

        .dark .hourly-forecast::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.05);
        }

        .hourly-forecast::-webkit-scrollbar-thumb {
            background: rgba(0, 0, 0, 0.2);
            border-radius: 3px;
        }

        .dark .hourly-forecast::-webkit-scrollbar-thumb {
            background: rgba(255, 255, 255, 0.2);
        }

        .hour-item {
            flex-shrink: 0;
            text-align: center;
            min-width: 70px;
            padding: 12px 10px;
            background: rgba(0, 0, 0, 0.05);
            border-radius: 8px;
            transition: all 0.3s ease;
            font-size: 12px;
            color: #000;
        }

        .dark .hour-item {
            background: rgba(255, 255, 255, 0.08);
            color: #fff;
        }

        .hour-item:hover {
            background: rgba(0, 0, 0, 0.1);
            transform: translateY(-2px);
        }

        .dark .hour-item:hover {
            background: rgba(255, 255, 255, 0.15);
        }

        @media (max-width: 768px) {
            .hour-item {
                min-width: 65px;
                padding: 10px 8px;
                font-size: 11px;
            }
        }

        .forecast-day {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 12px;
            margin-bottom: 8px;
            background: rgba(0, 0, 0, 0.03);
            border-radius: 8px;
            transition: all 0.3s ease;
            font-size: 13px;
            color: #000;
        }

        .dark .forecast-day {
            background: rgba(255, 255, 255, 0.05);
            color: #fff;
        }

        .forecast-day:hover {
            background: rgba(0, 0, 0, 0.08);
            transform: translateX(2px);
        }

        .dark .forecast-day:hover {
            background: rgba(255, 255, 255, 0.1);
        }

        @media (max-width: 768px) {
            .forecast-day {
                padding: 10px;
                margin-bottom: 6px;
                font-size: 12px;
            }
        }

        .weather-source {
            font-size: 11px;
            opacity: 0.6;
            text-align: center;
            margin-top: 12px;
            font-style: italic;
            color: #666;
        }

        .dark .weather-source {
            color: #999;
        }

        .weather-expanded h4 {
            color: #000;
            font-size: 13px;
        }

        .dark .weather-expanded h4 {
            color: #fff;
        }

        .hour-item {
            color: #000;
        }

        .dark .hour-item {
            color: #fff;
        }

        .forecast-day {
            color: #000;
        }

        .dark .forecast-day {
            color: #fff;
        }

        @media (max-width: 768px) {
            .weather-expanded {
                position: fixed;
                top: auto;
                bottom: 0;
                left: 0;
                right: 0;
                min-width: 100%;
                border-radius: 16px 16px 0 0;
                max-width: 100%;
                box-shadow: 0 -4px 12px rgba(0, 0, 0, 0.1);
            }

            .dark .weather-expanded {
                box-shadow: 0 -4px 12px rgba(0, 0, 0, 0.3);
            }

            .weather-expanded.show {
                max-height: 60vh;
                overflow-y: auto;
            }
        }
    </style>
</head>
<header id="header" class="<?php echo isset($headerClass) ? $headerClass : ''; ?> fixed w-full top-0 z-50 transition-all duration-300 bg-transparent dark:text-white">
    <div class="container mx-auto px-4 py-3">
        <div class="flex justify-between items-center">
            <div class="flex items-center space-x-4">
                <a href="/" class="flex items-center">
                    <img src="logo_new.png" alt="Vert Chasseur" class="h-12 block dark:hidden">
                    <img src="logo_dark.png" alt="Vert Chasseur" class="h-12 hidden dark:block">
                </a>
                <div id="weatherDesktop" class="hidden md:flex items-center">
                    <div class="weather-widget-container">
                        <button class="weather-widget" onclick="toggleWeatherWidget(event)">
                            <div class="weather-content">
                                <span id="tempDesktop">--°C</span>
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 14l-7 7m0 0l-7-7m7 7V3"/>
                                </svg>
                            </div>
                        </button>
                        <div id="weatherExpandedDesktop" class="weather-expanded">
                            <div class="weather-expanded-inner">
                                <div class="mb-4">
                                    <h4 class="text-sm font-medium mb-3">Prévisions par heure</h4>
                                    <div id="hourlyForecastDesktop" class="hourly-forecast">
                                        <div class="hour-item animate-pulse">--°</div>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <h4 class="text-sm font-medium mb-3">Prévisions 3 jours</h4>
                                    <div id="forecastDaysDesktop" class="space-y-2">
                                        <div class="forecast-day animate-pulse">Chargement...</div>
                                    </div>
                                </div>
                                <div class="weather-source">Données par WeatherAPI - IRM</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="flex items-center space-x-6">
                <nav class="hidden md:flex space-x-6">
                    <a href="/media" class="hover:text-gray-600 dark:hover:text-gray-300 text-sm font-medium">Actualités</a>
                    <a href="/shop" class="hover:text-gray-600 dark:hover:text-gray-300 text-sm font-medium">Commerces</a>
                    <a href="https://imators.com/support" class="hover:text-gray-600 dark:hover:text-gray-300 text-sm font-medium">Contact</a>
                </nav>
                <div class="flex items-center space-x-4">
                    <div id="weatherMobile" class="md:hidden text-sm font-medium">
                        <span id="tempMobile">--°C</span>
                    </div>
                    <a href="https://www.instagram.com/vert.chasseur" target="_blank" rel="noopener noreferrer" class="hover:text-gray-600 dark:hover:text-gray-300 transition-colors">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.266.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zM5.838 12a6.162 6.162 0 1 1 12.324 0 6.162 6.162 0 0 1-12.324 0zM12 16a4 4 0 1 1 0-8 4 4 0 0 1 0 8zm4.965-10.322a1.44 1.44 0 1 1 2.881.001 1.44 1.44 0 0 1-2.881-.001z"/></svg>
                    </a>
                    <button id="menuBtn" class="md:hidden w-6 h-6">
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 6h16M4 12h16M4 18h16"/></svg>
                    </button>
                </div>
            </div>
        </div>
    </div>
    <div id="mobileMenu" class="fixed inset-0 bg-white dark:bg-black transform translate-x-full transition-transform duration-300 md:hidden">
        <div class="flex justify-end p-4">
            <button id="closeBtn" class="w-6 h-6 text-black dark:text-white">
                <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M6 18L18 6M6 6l12 12"/></svg>
            </button>
        </div>
        <div class="flex justify-center my-4">
            <img src="logo_new.png" alt="Vert Chasseur" class="h-12 block dark:hidden">
            <img src="logo_dark.png" alt="Vert Chasseur" class="h-12 hidden dark:block">
        </div>
        <nav class="mt-8 p-4">
            <ul class="space-y-6 text-center">
                <li><a href="/media" class="block text-lg text-black dark:text-white">Actualités</a></li>
                <li><a href="/shop" class="block text-lg text-black dark:text-white">Commerces</a></li>
                <li><a href="https://www.instagram.com/vert.chasseur" class="block text-lg text-black dark:text-white">Instagram</a></li>
            </ul>
        </nav>
    </div>
</header>

<script>
    const header = document.getElementById('header');
    const menuBtn = document.getElementById('menuBtn');
    const closeBtn = document.getElementById('closeBtn');
    const mobileMenu = document.getElementById('mobileMenu');
    let weatherExpanded = false;

    window.addEventListener('scroll', () => {
        if (window.scrollY > 50) {
            header.classList.add('bg-white', 'dark:bg-black', 'shadow-sm', 'dark:shadow-gray-800');
        } else {
            header.classList.remove('bg-white', 'dark:bg-black', 'shadow-sm', 'dark:shadow-gray-800');
        }
    });

    menuBtn.addEventListener('click', () => mobileMenu.classList.remove('translate-x-full'));
    closeBtn.addEventListener('click', () => mobileMenu.classList.add('translate-x-full'));

    function toggleWeatherWidget(e) {
        e.preventDefault();
        e.stopPropagation();
        
        const expandedId = 'weatherExpandedDesktop';
        const expanded = document.getElementById(expandedId);
        
        weatherExpanded = !weatherExpanded;
        
        if (weatherExpanded) {
            expanded.classList.add('show');
            loadHourlyWeather();
            loadForecast();
        } else {
            expanded.classList.remove('show');
        }
    }

    async function fetchWeather() {
        try {
            const apiKey = 'fa1a36a37c3f4e7ab7e233043252305';
            const city = 'Uccle,Belgium';
            const url = `https://api.weatherapi.com/v1/current.json?key=${apiKey}&q=${city}&aqi=no`;
            
            const response = await fetch(url);
            
            if (!response.ok) {
                throw new Error('Erreur API Weather');
            }

            const data = await response.json();
            
            if (data && data.current && data.current.temp_c) {
                const temperature = Math.round(data.current.temp_c);
                document.getElementById('tempDesktop').textContent = `${temperature}°C`;
                document.getElementById('tempMobile').textContent = `${temperature}°C`;
            } else {
                throw new Error('Données météo non trouvées');
            }
        } catch (error) {
            console.error('Erreur météo:', error);
            document.getElementById('tempDesktop').textContent = '--°C';
            document.getElementById('tempMobile').textContent = '--°C';
        }
    }

    async function loadHourlyWeather() {
        try {
            const apiKey = 'fa1a36a37c3f4e7ab7e233043252305';
            const city = 'Uccle,Belgium';
            const url = `https://api.weatherapi.com/v1/forecast.json?key=${apiKey}&q=${city}&hours=24&lang=fr`;
            
            const response = await fetch(url);
            
            if (!response.ok) {
                throw new Error('Erreur API');
            }

            const data = await response.json();
            const currentHour = new Date().getHours();
            let hourlyHtml = '';

            for (let i = 0; i < 12; i++) {
                const hour = data.forecast.forecastday[0].hour[(currentHour + i) % 24];
                const hourTime = new Date(hour.time);
                const displayHour = i === 0 ? 'Now' : hourTime.getHours() + 'h';
                
                hourlyHtml += `
                    <div class="hour-item">
                        <div class="mb-1">${displayHour}</div>
                        <img src="https:${hour.condition.icon}" alt="${hour.condition.text}" class="w-6 h-6 mx-auto mb-1">
                        <div class="font-bold">${Math.round(hour.temp_c)}°</div>
                    </div>
                `;
            }

            document.getElementById('hourlyForecastDesktop').innerHTML = hourlyHtml;
            document.getElementById('hourlyForecastMobile').innerHTML = hourlyHtml;
        } catch (error) {
            console.error('Erreur prévisions horaires:', error);
        }
    }

    async function loadForecast() {
        try {
            const apiKey = 'fa1a36a37c3f4e7ab7e233043252305';
            const city = 'Uccle,Belgium';
            const url = `https://api.weatherapi.com/v1/forecast.json?key=${apiKey}&q=${city}&days=3&lang=fr`;
            
            const response = await fetch(url);
            
            if (!response.ok) {
                throw new Error('Erreur API');
            }

            const data = await response.json();
            let forecastHtml = '';

            data.forecast.forecastday.forEach((day, index) => {
                const date = new Date(day.date);
                const dayName = index === 0 ? 'Aujourd\'hui' : 
                               index === 1 ? 'Demain' : 
                               date.toLocaleDateString('fr-FR', { weekday: 'short' });
                
                forecastHtml += `
                    <div class="forecast-day">
                        <div class="flex items-center space-x-2">
                            <img src="https:${day.day.condition.icon}" alt="${day.day.condition.text}" class="w-6 h-6">
                            <div>
                                <div class="font-medium text-sm">${dayName}</div>
                                <div class="text-xs opacity-75">${day.day.condition.text}</div>
                            </div>
                        </div>
                        <div class="text-right">
                            <div class="font-bold text-sm">${Math.round(day.day.maxtemp_c)}°</div>
                            <div class="text-xs opacity-75">${Math.round(day.day.mintemp_c)}° • ${Math.round(day.day.avghumidity)}%</div>
                        </div>
                    </div>
                `;
            });

            document.getElementById('forecastDaysDesktop').innerHTML = forecastHtml;
            document.getElementById('forecastDaysMobile').innerHTML = forecastHtml;
        } catch (error) {
            console.error('Erreur prévisions:', error);
        }
    }

    fetchWeather();
    setInterval(fetchWeather, 10000);

    document.addEventListener('click', (e) => {
        if (weatherExpanded && !e.target.closest('.weather-widget-container')) {
            weatherExpanded = false;
            document.getElementById('weatherExpandedDesktop').classList.remove('show');
        }
    });
</script>
</body>
</html>