<?php
session_start();
include 'db.php';

if (!isset($_SESSION['resident_id'])) {
    echo json_encode(['success' => false, 'message' => 'Non autorisé.']);
    exit;
}

$resident_id = $_SESSION['resident_id'];

// Vérifie si un fichier a été envoyé
if (!isset($_FILES['profile_pic']) || $_FILES['profile_pic']['error'] !== UPLOAD_ERR_OK) {
    echo json_encode(['success' => false, 'message' => 'Aucun fichier reçu ou erreur d\'upload : ' . $_FILES['profile_pic']['error']]);
    exit;
}

// Récupère l'extension du fichier
$fileName = basename($_FILES['profile_pic']['name']);
$fileExtension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

// Crée le dossier "uploads" s'il n'existe pas
$uploadDir = 'uploads/';
if (!file_exists($uploadDir)) {
    mkdir($uploadDir, 0777, true);
}

// Génère un nom unique et sécurisé pour le fichier
$newName = 'profile_' . $resident_id . '_' . time() . '.' . $fileExtension;
$targetPath = $uploadDir . $newName;

// Déplace le fichier uploadé
if (move_uploaded_file($_FILES['profile_pic']['tmp_name'], $targetPath)) {
    // Met à jour la base de données
    $stmt = $conn->prepare("UPDATE residents SET img_profile = ? WHERE id = ?");
    $stmt->bind_param("si", $newName, $resident_id);

    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Fichier enregistré avec succès.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Erreur base de données : ' . $stmt->error]);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Erreur lors du déplacement du fichier.']);
}
?>
