<?php
$page_title = 'Family Members';
$family_id = $_SESSION['family_id'];

$stmt = $db->prepare("SELECT fm.*, u.username, u.email FROM family_members fm
                     JOIN users u ON fm.user_id = u.id
                     WHERE fm.family_id = ?
                     ORDER BY fm.role = 'admin' DESC, u.username");
$stmt->execute([$family_id]);
$members = $stmt->fetchAll();

$is_admin = is_admin($db, $family_id);
$action = isset($_GET['action']) ? $_GET['action'] : '';

if ($action == 'send_invite' && $_SERVER['REQUEST_METHOD'] == 'POST' && $is_admin) {
    $email = $_POST['email'];
    $invite_code = bin2hex(random_bytes(16));
    
    $stmt = $db->prepare("INSERT INTO family_invites (family_id, email, invite_code, invited_by, created_at) 
                         VALUES (?, ?, ?, ?, NOW())");
    $stmt->execute([$family_id, $email, $invite_code, $_SESSION['user_id']]);
    
    $invite_url = "https://" . $_SERVER['HTTP_HOST'] . "/join.php?code=" . $invite_code;
    
    $stmt = $db->prepare("SELECT family_name FROM families WHERE id = ?");
    $stmt->execute([$family_id]);
    $family_name = $stmt->fetchColumn();
    
    $stmt = $db->prepare("SELECT username FROM users WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $inviter_name = $stmt->fetchColumn();
    
    $subject = "$inviter_name invites you to join their family on AndWeare";
    $message = "
    <html>
    <head>
        <title>Family Invitation</title>
    </head>
    <body>
        <div style='font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;'>
            <div style='background-color: #f0f9ff; padding: 20px; text-align: center;'>
                <img src='https://" . $_SERVER['HTTP_HOST'] . "/assets/images/logo.png' alt='AndWeare Logo' style='height: 50px;'>
            </div>
            <div style='padding: 20px; border: 1px solid #e0f2fe; border-top: none;'>
                <h2 style='color: #0369a1;'>You've been invited!</h2>
                <p>Hello,</p>
                <p><strong>$inviter_name</strong> has invited you to join the <strong>$family_name</strong> family on AndWeare, your private family hub.</p>
                <p>With AndWeare, you can:</p>
                <ul>
                    <li>Share family photos privately</li>
                    <li>Keep track of important family events</li>
                    <li>Stay connected with your loved ones</li>
                </ul>
                <div style='text-align: center; margin: 30px 0;'>
                    <a href='$invite_url' style='background-color: #0ea5e9; color: white; padding: 12px 24px; text-decoration: none; border-radius: 4px; font-weight: bold;'>Accept Invitation</a>
                </div>
                <p>Or copy and paste this link into your browser:</p>
                <p style='font-size: 14px; word-break: break-all; background-color: #f0f9ff; padding: 10px;'>$invite_url</p>
                <p>This invitation will expire in 7 days.</p>
            </div>
            <div style='background-color: #f0f9ff; padding: 15px; text-align: center; font-size: 12px; color: #0369a1;'>
                &copy; " . date('Y') . " AndWeare - A product by Imators
            </div>
        </div>
    </body>
    </html>
    ";
    
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= "From: AndWeare <noreply@andweare.com>" . "\r\n";
    
    mail($email, $subject, $message, $headers);
    
    header("Location: ?page=members&invite_sent=1");
    exit;
}

if ($action == 'remove_member' && $is_admin && isset($_GET['id'])) {
    $member_id = $_GET['id'];
    
    $stmt = $db->prepare("SELECT role FROM family_members WHERE id = ?");
    $stmt->execute([$member_id]);
    $member_role = $stmt->fetchColumn();
    
    if ($member_role != 'admin' || count(array_filter($members, function($m) { return $m['role'] == 'admin'; })) > 1) {
        $stmt = $db->prepare("DELETE FROM family_members WHERE id = ? AND family_id = ?");
        $stmt->execute([$member_id, $family_id]);
    }
    
    header("Location: ?page=members");
    exit;
}

if ($action == 'resend_invite' && $is_admin && isset($_GET['id'])) {
    $invite_id = $_GET['id'];
    
    $stmt = $db->prepare("SELECT email, invite_code FROM family_invites WHERE id = ? AND family_id = ?");
    $stmt->execute([$invite_id, $family_id]);
    $invite = $stmt->fetch();
    
    if ($invite) {
        $invite_url = "https://" . $_SERVER['HTTP_HOST'] . "/join.php?code=" . $invite['invite_code'];
        
        $stmt = $db->prepare("SELECT family_name FROM families WHERE id = ?");
        $stmt->execute([$family_id]);
        $family_name = $stmt->fetchColumn();
        
        $stmt = $db->prepare("SELECT username FROM users WHERE id = ?");
        $stmt->execute([$_SESSION['user_id']]);
        $inviter_name = $stmt->fetchColumn();
        
        $subject = "$inviter_name invites you to join their family on AndWeare";
        $message = "
        <html>
        <head>
            <title>Family Invitation</title>
        </head>
        <body>
            <div style='font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;'>
                <div style='background-color: #f0f9ff; padding: 20px; text-align: center;'>
                    <img src='https://" . $_SERVER['HTTP_HOST'] . "/assets/images/logo.png' alt='AndWeare Logo' style='height: 50px;'>
                </div>
                <div style='padding: 20px; border: 1px solid #e0f2fe; border-top: none;'>
                    <h2 style='color: #0369a1;'>You've been invited!</h2>
                    <p>Hello,</p>
                    <p><strong>$inviter_name</strong> has invited you to join the <strong>$family_name</strong> family on AndWeare, your private family hub.</p>
                    <p>With AndWeare, you can:</p>
                    <ul>
                        <li>Share family photos privately</li>
                        <li>Keep track of important family events</li>
                        <li>Stay connected with your loved ones</li>
                    </ul>
                    <div style='text-align: center; margin: 30px 0;'>
                        <a href='$invite_url' style='background-color: #0ea5e9; color: white; padding: 12px 24px; text-decoration: none; border-radius: 4px; font-weight: bold;'>Accept Invitation</a>
                    </div>
                    <p>Or copy and paste this link into your browser:</p>
                    <p style='font-size: 14px; word-break: break-all; background-color: #f0f9ff; padding: 10px;'>$invite_url</p>
                    <p>This invitation will expire in 7 days.</p>
                </div>
                <div style='background-color: #f0f9ff; padding: 15px; text-align: center; font-size: 12px; color: #0369a1;'>
                    &copy; " . date('Y') . " AndWeare - A product by Imators
                </div>
            </div>
        </body>
        </html>
        ";
        
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        $headers .= "From: AndWeare <noreply@andweare.com>" . "\r\n";
        
        mail($invite['email'], $subject, $message, $headers);
        
        $stmt = $db->prepare("UPDATE family_invites SET updated_at = NOW() WHERE id = ?");
        $stmt->execute([$invite_id]);
    }
    
    header("Location: ?page=members&invite_resent=1");
    exit;
}

if ($action == 'cancel_invite' && $is_admin && isset($_GET['id'])) {
    $invite_id = $_GET['id'];
    
    $stmt = $db->prepare("DELETE FROM family_invites WHERE id = ? AND family_id = ?");
    $stmt->execute([$invite_id, $family_id]);
    
    header("Location: ?page=members");
    exit;
}

$stmt = $db->prepare("SELECT * FROM family_invites WHERE family_id = ? AND accepted = 0 ORDER BY created_at DESC");
$stmt->execute([$family_id]);
$pending_invites = $stmt->fetchAll();
?>

<div class="container mx-auto px-4">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">Family Members</h1>
        <?php if ($is_admin): ?>
        <a href="?page=members&action=invite" class="bg-indigo-600 hover:bg-indigo-700 text-white px-4 py-2 rounded-lg transition">
            Invite New Member
        </a>
        <?php endif; ?>
    </div>
    
    <?php if (isset($_GET['invite_sent'])): ?>
    <div class="mb-6 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded">
        <p>Invitation sent successfully!</p>
    </div>
    <?php endif; ?>
    
    <?php if (isset($_GET['invite_resent'])): ?>
    <div class="mb-6 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded">
        <p>Invitation resent successfully!</p>
    </div>
    <?php endif; ?>
    
    <div class="bg-white shadow rounded-lg overflow-hidden mb-6">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Member</th>
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Role</th>
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email</th>
                    <?php if ($is_admin): ?>
                    <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    <?php endif; ?>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php foreach ($members as $member): ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="flex items-center">
                            <div class="flex-shrink-0 h-10 w-10 rounded-full bg-gray-200 flex items-center justify-center overflow-hidden">
                                <img src="/assets/images/default-avatar.png" alt="<?php echo htmlspecialchars($member['username']); ?>" class="h-full w-full object-cover">
                            </div>
                            <div class="ml-4">
                                <div class="text-sm font-medium text-gray-900"><?php echo htmlspecialchars($member['username']); ?></div>
                            </div>
                        </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                            <?php echo $member['role'] == 'admin' ? 'bg-indigo-100 text-indigo-800' : 'bg-gray-100 text-gray-800'; ?>">
                            <?php echo ucfirst(htmlspecialchars($member['role'])); ?>
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                        <?php echo htmlspecialchars($member['email']); ?>
                    </td>
                    <?php if ($is_admin): ?>
                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                        <?php if ($member['user_id'] != $_SESSION['user_id']): ?>
                        <a href="?page=members&action=remove_member&id=<?php echo $member['id']; ?>" 
                           onclick="return confirm('Are you sure you want to remove this member?')"
                           class="text-red-600 hover:text-red-900">Remove</a>
                        <?php endif; ?>
                    </td>
                    <?php endif; ?>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    
    <?php if ($is_admin && !empty($pending_invites)): ?>
    <h2 class="text-xl font-medium mb-4">Pending Invitations</h2>
    <div class="bg-white shadow rounded-lg overflow-hidden mb-6">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email</th>
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Invited On</th>
                    <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php foreach ($pending_invites as $invite): ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                        <?php echo htmlspecialchars($invite['email']); ?>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                        <?php echo date('M j, Y', strtotime($invite['created_at'])); ?>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                        <a href="?page=members&action=resend_invite&id=<?php echo $invite['id']; ?>" class="text-indigo-600 hover:text-indigo-900 mr-4">Resend</a>
                        <a href="?page=members&action=cancel_invite&id=<?php echo $invite['id']; ?>" class="text-red-600 hover:text-red-900">Cancel</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php endif; ?>
</div>

<?php if ($action == 'invite' && $is_admin): ?>
<div class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50">
    <div class="bg-white rounded-lg w-full max-w-md p-6">
        <div class="flex justify-between items-center mb-4">
            <h3 class="text-xl font-medium">Invite New Member</h3>
            <a href="?page=members" class="text-gray-400 hover:text-gray-500">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                </svg>
            </a>
        </div>
        
        <form action="?page=members&action=send_invite" method="post">
            <div class="mb-4">
                <label for="email" class="block text-sm font-medium text-gray-700 mb-1">Email Address</label>
                <input type="email" id="email" name="email" required class="w-full px-3 py-2 border border-gray-300 rounded-md">
                <p class="mt-1 text-sm text-gray-500">An invitation link will be sent to this email address.</p>
            </div>
            
            <div class="flex justify-end">
                <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white px-4 py-2 rounded-lg transition">Send Invitation</button>
            </div>
        </form>
    </div>
</div>
<?php endif; ?>